{
  onModifyTypePriority: -1,
  onModifyType(move, pokemon) {
    const noModifyType = [
      "judgment", "multiattack", "naturalgift", "revelationdance",
      "technoblast", "terrainpulse", "weatherball"
    ];
    if (
      move.type === "Normal" &&
      !noModifyType.includes(move.id) &&
      !(move.isZ && move.category !== "Status") &&
      !(move.name === "Tera Blast" && pokemon.terastallized)
    ) {
      move.type = "Flying";
      move.typeChangerBoosted = this.effect;
    }
  },
onBasePowerPriority: 23,
onBasePower(basePower, pokemon, target, move) {
  if (move.type === "Flying") {
    return this.chainModify([1.5, 1]);
  }
},
onTryHit(target, source, move) {
  if (move.type === 'Ground' && !this.field.pseudoWeather.gravity) {
    this.add('-immune', target, '[from] ability: Mystic Wings');
    return null;
  }
},
  onDamage(damage, target, source, effect) {
    const move = effect?.effectType === 'Move' ? effect : null;
    if (!move) return;

    const flyingWeaknesses = ['Electric', 'Ice', 'Rock'];
    if (flyingWeaknesses.includes(move.type)) {
      this.debug(`Mystic Wings: amplifying ${move.type}-type damage`);
      return this.chainModify(2);
    }
  },
  onSwitchIn(pokemon) {
    const sideConditions = pokemon.side.sideConditions;
    for (const hazard of ['spikes', 'toxicspikes', 'stickyweb']) {
      if (sideConditions[hazard]) {
        this.add('-activate', pokemon, 'ability: Mystic Wings');
        this.add('-message', `${pokemon.name} is unaffected by ${hazard.replace(/([a-z])([A-Z])/g, '$1 $2')}.`);
        delete pokemon.volatiles[hazard];
      }
    }
  },
  flags: {},
  name: "Mystic Wings",
  rating: 4.5
}