{
  name: "Override",

  onStart(pokemon) {
    if (pokemon.baseSpecies.baseSpecies !== 'porygonx') return;

    for (const target of pokemon.foes()) {
      const targetAbility = target.getAbility().id;

      if (!targetAbility || ['override', 'trace'].includes(targetAbility)) continue;

      this.add('-ability', pokemon, 'Override');
      this.add(`-${pokemon.name} is Overriding ${target.name}'s ability!`);

      pokemon.m.overrideOriginalAbility = 'override';
      target.m.overrideOriginalAbility = targetAbility;

      target.setAbility('override');
      pokemon.setAbility(targetAbility);
      break;
    }
  },

  onSwitchOut(pokemon) {
    const origSelf = pokemon.m.overrideOriginalAbility;
    if (origSelf) {
      pokemon.setAbility(origSelf);
      this.add('-ability', pokemon, origSelf);
      delete pokemon.m.overrideOriginalAbility;
    }
  },

  onModifyDamage(damage, source, target, move) {
    if (move.type === 'Normal') {
      return this.chainModify(1.2);
    }
  },
}