{
onAfterMove(source, target, move) {
    if (!source || !target) return;
    if (move.category === 'Status') return;
    if (!move.basePower || move.basePower <= 0) return;

    const bonusPower = Math.floor(move.basePower * 0.33);
    if (bonusPower <= 0) return;

    const effectiveDefense = move.category === 'Physical'
        ? target.getStat('spd')
        : target.getStat('def');

    const attackStat = move.category === 'Physical'
        ? source.getStat('atk')
        : source.getStat('spa');

    const fakeMove = {
        name: "Shadow Scythe",
        basePower: 1,
        effectType: 'Move',
        category: move.category,
        type: move.type,
    };

    if (source.hasType(move.type)) {
    fakeMove.stab = true;
}

    const scaledDamage = Math.max(
        1,
        Math.floor((bonusPower * attackStat) / effectiveDefense)
    );

    this.damage(scaledDamage, target, source, fakeMove);
},

flags: {},
name: "Shadow Scythe",
rating: 4.5,
}