{
onAfterMove(source, target, move) {
    if (!source || !target) return;
    if (move.category === 'Status') return;
    if (!move.basePower || move.basePower <= 0) return;

    const bonusPower = Math.floor(move.basePower * 0.33);
    if (bonusPower > 0) {
        const effectiveDefense = move.category === 'Physical'
            ? target.getStat('spd')
            : target.getStat('def');

        const attackStat = move.category === 'Physical'
            ? source.getStat('atk')
            : source.getStat('spa');

        const fakeMove = {
            name: "Ascended Scythe",
            basePower: 1,
            effectType: 'Move',
            category: move.category,
            type: move.type,
        };

        if (source.hasType(move.type) || move.type === 'Normal' || move.type === 'Fighting') {
            fakeMove.stab = true;
        }

        const scaledDamage = Math.max(
            1,
            Math.floor((bonusPower * attackStat) / effectiveDefense)
        );

        this.damage(scaledDamage, target, source, fakeMove);
    }

    const hitData = target.getMoveHitData(move);
    if (hitData?.damage && hitData.damage > 0) {
        const healAmount = Math.floor(hitData.damage * 0.33);
        if (healAmount > 0) {
            this.heal(healAmount, source);
        }
    }
},

onModifyMove(move, source) {
    if (!move) return;
    if (move.type === 'Normal' || move.type === 'Fighting') {
        move.stab = true;
    }
},

flags: {},
name: "We Are One",
rating: 5,
}