{
		name: "Wheel of Adaptation",
		onStart(pokemon) {
			pokemon.addVolatile('wheelofadaptation');
		},
		onSwitchOut(pokemon) {
			pokemon.removeVolatile('wheelofadaptation');
		},
		onDamagingHit(damage, target, source, move) {
			if (!move.type || move.category === 'Status') return;

			const resistances = target.volatiles['wheelofadaptation']?.resistances || {};
			if (!resistances[move.type]) {
				this.add('-ability', target, 'Wheel of Adaptation');
				this.add('-message', `${target.name} adapted to resist ${move.type}-type moves!`);
				target.volatiles['wheelofadaptation'].resistances[move.type] = true;
			}
		},
		onEffectiveness(typeMod, target, type, move) {
			if (!target?.hasAbility('wheelofadaptation')) return;
			const volatile = target.volatiles['wheelofadaptation'];
			if (!volatile?.resistances?.[move.type]) return;

			if (typeMod > 0) return typeMod - 2;
			if (typeMod === 0) return -1;
		},
		condition: {
			noCopy: true,
			duration: Infinity,
			onStart(pokemon) {
				this.effectState.resistances = {};
			},
		},
	}