{
    name: "Wheel of Domination",
    rating: 3,
    shortDesc: "After hitting with a damaging move, the next damaging move deals 2× damage.",

    onStart(pokemon) {
      pokemon.wheelReady = false;
    },

    onAfterMove(pokemon, target, move) {
      if (move?.category !== 'Status') {
        if (!pokemon.wheelReady) {
          pokemon.wheelReady = true;
          this.add(`-activate`, pokemon, "ability: Wheel of Domination");
        } else {
        }
      } else {
        pokemon.wheelReady = false;
      }
    },

    onBasePower(basePower, attacker, defender, move) {
      if (attacker.wheelReady && move.category !== 'Status') {
        this.debug('Wheel of Domination boost applied');
        attacker.wheelReady = false;
        return this.chainModify(2.0);
      }
    },

    onSwitchOut(pokemon) {
      if (pokemon.wheelReady) {
        this.add(`-end`, pokemon, "Wheel of Domination");
      }
      delete pokemon.wheelReady;
    },
  }