{
  name: "Whiplash",
  rating: 4,
onSourceAfterFaint(length, target, source, effect) {
  if (!source || source.fainted) return;

  if (source.hasMove('powerwhip')) {
    if (source.whiplashBoostActive) return;
    source.whiplashBoostActive = true;
    this.add('-ability', source, 'Whiplash');
    this.add(`-${source.name}'s Power Whip surges with strength!`);
  } else {
    this.add('-ability', source, 'Whiplash');
    this.heal(source.maxhp / 4, source);
    this.add(`-${source.name} recovers from the takedown!`);
  }
},

onModifyMove(move, pokemon) {
  if (
    move.id === 'powerwhip' &&
    pokemon.getAbility().id === 'whiplash' &&
    pokemon.whiplashBoostActive
  ) {
    move.accuracy = true;
    move.secondaries = move.secondaries || [];
    move.secondaries.push({
      chance: 33,
      status: 'psn',
    });
  }
},

onBasePower(basePower, attacker, defender, move) {
  if (
    move.id === 'powerwhip' &&
    attacker.getAbility().id === 'whiplash' &&
    attacker.whiplashBoostActive
  ) {
    this.debug('Whiplash boost to Power Whip');
    return this.chainModify(1.33);
  }
},
}