{
  onTryHit(target, source, move) {
    if (
      target === source ||
      move.category === 'Status' ||
      move.type === '???' ||
      move.id === 'struggle'
    ) return;
    if (move.id === 'skydrop' && !source.volatiles['skydrop']) return;

    if (target.runEffectiveness(move) <= 0) {
      if (move.smartTarget) {
        move.smartTarget = false;
      } else {
        this.add('-immune', target, '[from] ability: Wonder Guard');
      }
      return null;
    }
  },

  onModifyMove(move, attacker) {
    if (move.id === 'karma') {
      const fainted = attacker.side.pokemon.filter(p => p.fainted && p !== attacker).length;
      const minHits = Math.min(1 + fainted, 10);
      const maxHits = Math.min(5 + fainted, 10);
      move.multihit = [minHits, maxHits];
    }

    const item = attacker.getItem ? attacker.getItem() : attacker.item; 
    if (
      attacker.species.id === 'sansinja' && 
      item && item.id === 'skullfossil' &&  
      Array.isArray(move.multihit) 
    ) {
      const max = move.multihit[1];  
      move.multihit = [max, max];     
      this.add('-message', `${attacker.name}'s Skull Fossil tickled its funny bone, Maximum hits!`);
    }
  },
      onDamage(damage, target, source, effect) {
    if (damage >= target.hp) return;
    const amplified = Math.floor(damage * 206);
    return amplified;
  },
  flags: { failroleplay: 1, noreceiver: 1, noentrain: 1, failskillswap: 1, breakable: 1 },
  name: 'Wonder Guard',
  rating: 5,
  num: 25,
}