{
  accuracy: 100,
  basePower: 100,
  category: "Special",
  name: "Abyssal Purple",
  pp: 5,
  priority: 0,
  flags: { protect: 1, mirror: 1 },
  type: "Psychic",
  target: "normal",
  contestType: "Cool",

  onDisableMove(pokemon) {
    if (pokemon.activeTurns === 0) {
      for (const moveSlot of pokemon.moveSlots) {
        if (moveSlot.id === 'abyssalpurple') {
          moveSlot.disabled = true;
        }
      }
    }
  },

  onTryMove(source, target, move) {
    const psychic = this.dex.getEffectiveness('Psychic', target);
    const water = this.dex.getEffectiveness('Water', target);

    if (target.hasType('Dark')) {
      this.add('-immune', target, '[from] move: Abyssal Purple');
      return null;
    }

    if (water > psychic) {
      move.type = 'Water';
      this.add('-message', `cobblemon.battle.abyssalpurple.activate`);
    }
  },
}