{
  name: "Copying Cleave",
  accuracy: 100,
  basePower: 80,
  category: "Physical",
  type: "Ghost",
  pp: 10,
  priority: 0,
  flags: { contact: 1, protect: 1, mirror: 1, slicing: 1 },
  onHit(target, source, move) {
    if (!target || target.fainted) return;

    let i;
    for (i in target.boosts) {
      source.boosts[i] = target.boosts[i];
    }

    const volatilesToCopy = ["focusenergy", "gmaxchistrike", "laserfocus"];
    for (const volatile of volatilesToCopy) {
      if (target.volatiles[volatile]) {
        source.addVolatile(volatile);
        if (volatile === "gmaxchistrike")
          source.volatiles[volatile].layers = target.volatiles[volatile].layers;
      } else {
        source.removeVolatile(volatile);
      }
    }

    this.add("-copyboost", source, target, "[from] move: Copying Cleave");
  },
  secondary: null,
  target: "normal",
  contestType: "Clever"
}