{
  name: "Cyber Spin",
  type: "Steel",
  category: "Physical",
  basePower: 75,
  accuracy: 100,
  pp: 10,
  priority: 0,
  flags: { protect: 1, mirror: 1 },
  onPrepareHit(target, source, move) {
    const atk = source.getStat('atk', false, true);
    const def = source.getStat('def', false, true);
    if (def > atk) {
      move.overrideOffensiveStat = 'def';
    } else {
      move.overrideOffensiveStat = 'atk';
    }
  },
  onHit(target, source, move) {
    const sideConditions = ['spikes', 'toxicspikes', 'stealthrock', 'stickyweb'];
    for (const condition of sideConditions) {
      if (source.side.removeSideCondition(condition)) {
        this.add('-sideend', source.side, this.dex.conditions.get(condition).name, '[from] move: Cyber Spin');
      }
    }

    if (source.volatiles['leechseed']) {
      delete source.volatiles['leechseed'];
      this.add('-end', source, 'Leech Seed', '[from] move: Cyber Spin');
    }

    const traps = ['trapped', 'trapper'];
    for (const trap of traps) {
      if (source.volatiles[trap]) {
        delete source.volatiles[trap];
        this.add('-end', source, trap, '[from] move: Cyber Spin');
      }
    }
  },
  target: "normal"
}