{
  name: "Gluttony",
  type: "Normal",
  category: "Physical",
  basePower: 80,
  accuracy: 100,
  pp: 10,
  priority: 0,
  target: "normal",
  flags: { contact: 1, protect: 1, mirror: 1, metronome: 1, bite: 1 },
  onStart(pokemon) {
    if (!pokemon.gluttonyActivated) {
      pokemon.gluttonyActivated = false;
      pokemon.gluttonyData = null;
    }
  },

  onPrepareHit(target, source, move) {
    if (!source.gluttonyActivated && !source.gluttonyData) {
      source.gluttonyData = {
        boosted: false,
        newType: null,
      };
    }
  },

onAfterMoveSecondary(target, source, move) {
  if (
    !source.gluttonyActivated &&
    target.fainted &&
    target.species &&
    target.species.types?.length
  ) {
    const targetPrimaryType = this.dex.species.get(target.species.id).types[0];
    if (targetPrimaryType) {
      source.gluttonyActivated = true;
      source.gluttonyData = {
        boosted: true,
        newType: targetPrimaryType,
      };
      this.add('-message', `${source.name} consumed its prey and Gluttony transformed into a ${targetPrimaryType} type move!`);
    }
  }
},
  onModifyTypePriority: -1,
  onModifyType(move, source) {
    if (source?.gluttonyData?.newType && move.id === 'gluttony') {
      move.type = source.gluttonyData.newType;
    }
  },

  onBasePowerPriority: 23,
  onBasePower(basePower, source, target, move) {
    if (source?.gluttonyData?.boosted && move.id === 'gluttony') {
      return this.chainModify([1.5, 1]);
    }
  },
}