{
  accuracy: 100,
  basePower: 65,
  category: "Special",
  name: "Psybeam Funnel",
  pp: 10,
  priority: 0,
  flags: { protect: 1, mirror: 1 },
  type: "Psychic",
  target: "normal",
  onHit(target, source) {
    if (!source.volatiles['psybeamfunnel']) {
      source.addVolatile('psybeamfunnel');
    }
  },
  condition: {
    duration: 4,
    onStart(pokemon) {
      this.add('-start', pokemon, 'Psybeam Funnel');
    },
    onAfterMove(source, target, move) {
      if (move.id === 'wingbeam') return;

      const opponent = source.side.foe.active.find(mon => mon && !mon.fainted);
      if (opponent) {
        this.actions.useMove("wingbeam", source, opponent);
      }
    },
    onEnd(pokemon) {
      this.add('-end', pokemon, 'Psybeam Funnel');
    },
  },
  contestType: "Cool"
}