{
  accuracy: 90,
  basePower: 40,
  basePowerCallback(pokemon, target, move) {
    if (target.beingCalledBack || target.switchFlag) {
      return move.basePower * 2;
    }
    return move.basePower;
  },

  category: "Physical",
  name: "Seeking Spear",
  pp: 10,
  priority: 0,
  flags: { protect: 1, mirror: 1, metronome: 1 },
  onHit(target, source) {
    if (!target.volatiles['seekingspear']) {
      target.addVolatile('seekingspear');
    }
  },
  condition: {
    name: "Seeking Spear",
    duration: 2,
    onStart(target) {
      this.add('-start', target, 'Seeking Spear');
    },
    onTrapPokemon(pokemon) {
      this.debug('Seeking Spear is trapping the target');
      pokemon.trapped = true;
    },
    onEnd(target) {
      this.add('-end', target, 'Seeking Spear');
    },
  },
  target: "normal",
  type: "Ghost",
  contestType: "Cool"
}