/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.bootstraplauncher;

import cpw.mods.cl.JarModuleFinder;
import cpw.mods.cl.ModuleClassLoader;
import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarContentsBuilder;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.niofs.union.UnionPathFilter;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.VisibleForTesting;

public class BootstrapLauncher {
    private static final boolean DEBUG = System.getProperties().containsKey("bsl.debug");

    @VisibleForTesting
    public static void unitTestingMain(String ... args) {
        System.err.println("*".repeat(80));
        System.err.println("Starting in unit testing mode. Misconfiguration may mask bugs that would occur in normal operation.");
        System.err.println("*".repeat(80));
        BootstrapLauncher.run(false, args);
    }

    public static void main(String ... args) {
        BootstrapLauncher.run(true, args);
    }

    private static void run(boolean classloaderIsolation, String ... args) {
        List<String> legacyClasspath = BootstrapLauncher.loadLegacyClassPath();
        System.setProperty("legacyClassPath", String.join((CharSequence)File.pathSeparator, legacyClasspath));
        Map<String, Path> loadedModules = BootstrapLauncher.findLoadedModules();
        String ignoreList = System.getProperty("ignoreList", "asm,securejarhandler");
        String[] ignores = ignoreList.split(",");
        HashSet previousPackages = new HashSet();
        ArrayList jars = new ArrayList();
        HashMap<Path, String> pathLookup = new HashMap<Path, String>();
        Map<String, String> filenameMap = BootstrapLauncher.getMergeFilenameMap();
        LinkedHashMap<String, List> mergeMap = new LinkedHashMap<String, List>();
        ArrayList<String> order = new ArrayList<String>();
        block7: for (String legacy : legacyClasspath) {
            String moduleName;
            Path path = Paths.get(legacy, new String[0]);
            String filename = path.getFileName().toString();
            for (String filter : ignores) {
                if (!filename.startsWith(filter)) continue;
                if (!DEBUG) continue block7;
                System.out.println("bsl: file '" + legacy + "' ignored because filename starts with '" + filter + "'");
                continue block7;
            }
            if (DEBUG) {
                System.out.println("bsl: encountered path '" + legacy + "'");
            }
            if (Files.notExists(path, new LinkOption[0])) continue;
            try (JarContents jarContent = JarContents.of((Path)path);){
                moduleName = JarMetadata.from((JarContents)jarContent).name();
            }
            catch (IOException | UncheckedIOException e2) {
                if (!DEBUG) continue;
                System.out.println("bsl: skipping '" + String.valueOf(path) + "' due to an IO error: " + String.valueOf(e2));
                continue;
            }
            if ("".equals(moduleName)) continue;
            Path existingModuleLocation = loadedModules.get(moduleName);
            if (existingModuleLocation != null) {
                if (!existingModuleLocation.equals(path)) {
                    throw new IllegalStateException("Module named " + moduleName + " was already on the JVMs module path loaded from " + String.valueOf(existingModuleLocation) + " but class-path contains it at location " + String.valueOf(path));
                }
                if (!DEBUG) continue;
                System.out.println("bsl: skipping '" + String.valueOf(path) + "' because it is already loaded on boot-path as " + moduleName);
                continue;
            }
            String jarname = pathLookup.computeIfAbsent(path, k -> filenameMap.getOrDefault(filename, moduleName));
            order.add(jarname);
            mergeMap.computeIfAbsent(jarname, k -> new ArrayList()).add(path);
        }
        mergeMap.entrySet().stream().sorted(Comparator.comparingInt(e -> order.indexOf(e.getKey()))).forEach(e -> {
            String name = (String)e.getKey();
            List paths = (List)e.getValue();
            if (paths.size() == 1 && Files.notExists((Path)paths.get(0), new LinkOption[0])) {
                return;
            }
            Path[] pathsArray = (Path[])paths.toArray(Path[]::new);
            JarContents jarContents = new JarContentsBuilder().paths(pathsArray).pathFilter((UnionPathFilter)new PackageTracker(Set.copyOf(previousPackages), pathsArray)).build();
            SecureJar jar = SecureJar.from((JarContents)jarContents);
            Set<String> packages = jar.moduleDataProvider().descriptor().packages();
            if (DEBUG) {
                System.out.println("bsl: the following paths are merged together in module " + name);
                paths.forEach(path -> System.out.println("bsl:    " + String.valueOf(path)));
                System.out.println("bsl: list of packages for module " + name);
                packages.forEach(p -> System.out.println("bsl:    " + p));
            }
            previousPackages.addAll(packages);
            jars.add(jar);
        });
        SecureJar[] secureJarsArray = (SecureJar[])jars.toArray(SecureJar[]::new);
        List<String> allTargets = Arrays.stream(secureJarsArray).map(SecureJar::name).toList();
        JarModuleFinder jarModuleFinder = JarModuleFinder.of((SecureJar[])secureJarsArray);
        Configuration bootModuleConfiguration = BootstrapLauncher.class.getModule().getLayer().configuration();
        Configuration bootstrapConfiguration = bootModuleConfiguration.resolveAndBind((ModuleFinder)jarModuleFinder, ModuleFinder.ofSystem(), allTargets);
        ClassLoader parentLoader = classloaderIsolation ? null : Thread.currentThread().getContextClassLoader();
        ModuleClassLoader moduleClassLoader = new ModuleClassLoader("MC-BOOTSTRAP", bootstrapConfiguration, List.of(BootstrapLauncher.class.getModule().getLayer()));
        ModuleLayer.Controller layer = ModuleLayer.defineModules(bootstrapConfiguration, List.of(BootstrapLauncher.class.getModule().getLayer()), m -> moduleClassLoader);
        Thread.currentThread().setContextClassLoader((ClassLoader)moduleClassLoader);
        ServiceLoader<Consumer> loader = ServiceLoader.load(layer.layer(), Consumer.class);
        loader.stream().findFirst().orElseThrow().get().accept(args);
    }

    private static Map<String, Path> findLoadedModules() {
        record ModuleWithLocation(String name, Path location) {
        }
        return ModuleLayer.boot().configuration().modules().stream().map(module -> {
            Path location;
            ModuleReference reference = module.reference();
            String moduleName = reference.descriptor().name();
            URI locationUri = reference.location().orElse(null);
            if (moduleName.isBlank() || locationUri == null) {
                return null;
            }
            try {
                location = new File(locationUri).toPath();
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
            return new ModuleWithLocation(moduleName, location);
        }).filter(Objects::nonNull).collect(Collectors.toMap(ModuleWithLocation::name, ModuleWithLocation::location));
    }

    private static Map<String, String> getMergeFilenameMap() {
        String mergeModules = System.getProperty("mergeModules");
        if (mergeModules == null) {
            return Map.of();
        }
        HashMap<String, String> filenameMap = new HashMap<String, String>();
        int i = 0;
        for (String merge : mergeModules.split(";")) {
            String[] targets;
            for (String target : targets = merge.split(",")) {
                filenameMap.put(target, String.valueOf(i));
            }
            ++i;
        }
        return filenameMap;
    }

    private static List<String> loadLegacyClassPath() {
        String legacyCpPath = System.getProperty("legacyClassPath.file");
        if (legacyCpPath != null) {
            Path legacyCPFileCandidatePath = Paths.get(legacyCpPath, new String[0]);
            try {
                return Files.readAllLines(legacyCPFileCandidatePath);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load the legacy class path from the specified file: " + legacyCpPath, e);
            }
        }
        String legacyClasspath = System.getProperty("legacyClassPath", System.getProperty("java.class.path"));
        Objects.requireNonNull(legacyClasspath, "Missing legacyClassPath, cannot bootstrap");
        if (legacyClasspath.isEmpty()) {
            return List.of();
        }
        return Arrays.asList(legacyClasspath.split(File.pathSeparator));
    }

    private record PackageTracker(Set<String> packages, Path[] paths) implements UnionPathFilter
    {
        public boolean test(String path, Path basePath) {
            if (this.packages.isEmpty() || path.startsWith("META-INF/")) {
                return true;
            }
            int idx = path.lastIndexOf(47);
            return idx < 0 || idx == path.length() - 1 || !this.packages.contains(path.substring(0, idx).replace('/', '.'));
        }
    }
}

