/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block;

import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockModelShaper {
    private Map<BlockState, BakedModel> modelByStateCache = Map.of();
    private final ModelManager modelManager;

    public BlockModelShaper(ModelManager p_110880_) {
        this.modelManager = p_110880_;
    }

    public TextureAtlasSprite getParticleIcon(BlockState p_110883_) {
        return this.getBlockModel(p_110883_).getParticleIcon();
    }

    public BakedModel getBlockModel(BlockState p_110894_) {
        BakedModel $$1 = this.modelByStateCache.get(p_110894_);
        if ($$1 == null) {
            $$1 = this.modelManager.getMissingModel();
        }
        return $$1;
    }

    public ModelManager getModelManager() {
        return this.modelManager;
    }

    public void replaceCache(Map<BlockState, BakedModel> p_248582_) {
        this.modelByStateCache = p_248582_;
    }

    public static ModelResourceLocation stateToModelLocation(BlockState p_110896_) {
        return BlockModelShaper.stateToModelLocation(BuiltInRegistries.BLOCK.getKey(p_110896_.getBlock()), p_110896_);
    }

    public static ModelResourceLocation stateToModelLocation(ResourceLocation p_110890_, BlockState p_110891_) {
        return new ModelResourceLocation(p_110890_, BlockModelShaper.statePropertiesToString(p_110891_.getValues()));
    }

    public static String statePropertiesToString(Map<Property<?>, Comparable<?>> p_110888_) {
        StringBuilder $$1 = new StringBuilder();
        for (Map.Entry<Property<?>, Comparable<?>> $$2 : p_110888_.entrySet()) {
            if ($$1.length() != 0) {
                $$1.append(',');
            }
            Property<?> $$3 = $$2.getKey();
            $$1.append($$3.getName());
            $$1.append('=');
            $$1.append(BlockModelShaper.getValue($$3, $$2.getValue()));
        }
        return $$1.toString();
    }

    private static <T extends Comparable<T>> String getValue(Property<T> p_110885_, Comparable<?> p_110886_) {
        return p_110885_.getName(p_110886_);
    }
}

