/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.item.AnimalArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;

public class WolfArmorLayer
extends RenderLayer<Wolf, WolfModel<Wolf>> {
    private final WolfModel<Wolf> model;
    private static final Map<Crackiness.Level, ResourceLocation> ARMOR_CRACK_LOCATIONS = Map.of(Crackiness.Level.LOW, ResourceLocation.withDefaultNamespace("textures/entity/wolf/wolf_armor_crackiness_low.png"), Crackiness.Level.MEDIUM, ResourceLocation.withDefaultNamespace("textures/entity/wolf/wolf_armor_crackiness_medium.png"), Crackiness.Level.HIGH, ResourceLocation.withDefaultNamespace("textures/entity/wolf/wolf_armor_crackiness_high.png"));

    public WolfArmorLayer(RenderLayerParent<Wolf, WolfModel<Wolf>> p_316639_, EntityModelSet p_316756_) {
        super(p_316639_);
        this.model = new WolfModel(p_316756_.bakeLayer(ModelLayers.WOLF_ARMOR));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void render(PoseStack p_316608_, MultiBufferSource p_316832_, int p_316312_, Wolf p_316642_, float p_316350_, float p_316147_, float p_316637_, float p_316734_, float p_316302_, float p_316605_) {
        void $$12;
        AnimalArmorItem $$11;
        if (!p_316642_.hasArmor()) {
            return;
        }
        ItemStack $$10 = p_316642_.getBodyArmorItem();
        Item item = $$10.getItem();
        if (!(item instanceof AnimalArmorItem) || ($$11 = (AnimalArmorItem)item).getBodyType() != AnimalArmorItem.BodyType.CANINE) {
            return;
        }
        ((WolfModel)this.getParentModel()).copyPropertiesTo(this.model);
        this.model.prepareMobModel(p_316642_, p_316350_, p_316147_, p_316637_);
        this.model.setupAnim(p_316642_, p_316350_, p_316147_, p_316734_, p_316302_, p_316605_);
        VertexConsumer $$13 = p_316832_.getBuffer(RenderType.entityCutoutNoCull($$12.getTexture()));
        this.model.renderToBuffer(p_316608_, $$13, p_316312_, OverlayTexture.NO_OVERLAY);
        this.maybeRenderColoredLayer(p_316608_, p_316832_, p_316312_, $$10, (AnimalArmorItem)$$12);
        this.maybeRenderCracks(p_316608_, p_316832_, p_316312_, $$10);
    }

    private void maybeRenderColoredLayer(PoseStack p_330741_, MultiBufferSource p_330339_, int p_332179_, ItemStack p_331250_, AnimalArmorItem p_330867_) {
        if (p_331250_.is(ItemTags.DYEABLE)) {
            int $$5 = DyedItemColor.getOrDefault(p_331250_, 0);
            if (FastColor.ARGB32.alpha($$5) == 0) {
                return;
            }
            ResourceLocation $$6 = p_330867_.getOverlayTexture();
            if ($$6 == null) {
                return;
            }
            this.model.renderToBuffer(p_330741_, p_330339_.getBuffer(RenderType.entityCutoutNoCull($$6)), p_332179_, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.opaque($$5));
        }
    }

    private void maybeRenderCracks(PoseStack p_331222_, MultiBufferSource p_331637_, int p_330931_, ItemStack p_331187_) {
        Crackiness.Level $$4 = Crackiness.WOLF_ARMOR.byDamage(p_331187_);
        if ($$4 == Crackiness.Level.NONE) {
            return;
        }
        ResourceLocation $$5 = ARMOR_CRACK_LOCATIONS.get((Object)$$4);
        VertexConsumer $$6 = p_331637_.getBuffer(RenderType.entityTranslucent($$5));
        this.model.renderToBuffer(p_331222_, $$6, p_330931_, OverlayTexture.NO_OVERLAY);
    }
}

