/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.AtlasSet;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.slf4j.Logger;

public class ModelManager
implements PreparableReloadListener,
AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<ResourceLocation, ResourceLocation> VANILLA_ATLASES = Map.of(Sheets.BANNER_SHEET, ResourceLocation.withDefaultNamespace("banner_patterns"), Sheets.BED_SHEET, ResourceLocation.withDefaultNamespace("beds"), Sheets.CHEST_SHEET, ResourceLocation.withDefaultNamespace("chests"), Sheets.SHIELD_SHEET, ResourceLocation.withDefaultNamespace("shield_patterns"), Sheets.SIGN_SHEET, ResourceLocation.withDefaultNamespace("signs"), Sheets.SHULKER_SHEET, ResourceLocation.withDefaultNamespace("shulker_boxes"), Sheets.ARMOR_TRIMS_SHEET, ResourceLocation.withDefaultNamespace("armor_trims"), Sheets.DECORATED_POT_SHEET, ResourceLocation.withDefaultNamespace("decorated_pot"), TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace("blocks"));
    private Map<ModelResourceLocation, BakedModel> bakedRegistry;
    private final AtlasSet atlases;
    private final BlockModelShaper blockModelShaper;
    private final BlockColors blockColors;
    private int maxMipmapLevels;
    private BakedModel missingModel;
    private Object2IntMap<BlockState> modelGroups;

    public ModelManager(TextureManager p_119406_, BlockColors p_119407_, int p_119408_) {
        this.blockColors = p_119407_;
        this.maxMipmapLevels = p_119408_;
        this.blockModelShaper = new BlockModelShaper(this);
        this.atlases = new AtlasSet(VANILLA_ATLASES, p_119406_);
    }

    public BakedModel getModel(ModelResourceLocation p_119423_) {
        return this.bakedRegistry.getOrDefault(p_119423_, this.missingModel);
    }

    public BakedModel getMissingModel() {
        return this.missingModel;
    }

    public BlockModelShaper getBlockModelShaper() {
        return this.blockModelShaper;
    }

    @Override
    public final CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier p_249079_, ResourceManager p_251134_, ProfilerFiller p_250336_, ProfilerFiller p_252324_, Executor p_250550_, Executor p_249221_) {
        p_250336_.startTick();
        CompletableFuture<Map<ResourceLocation, BlockModel>> $$6 = ModelManager.loadBlockModels(p_251134_, p_250550_);
        CompletableFuture<Map<ResourceLocation, List<BlockStateModelLoader.LoadedJson>>> $$7 = ModelManager.loadBlockStates(p_251134_, p_250550_);
        CompletionStage $$8 = $$6.thenCombineAsync($$7, (p_251201_, p_251281_) -> new ModelBakery(this.blockColors, p_250336_, (Map<ResourceLocation, BlockModel>)p_251201_, (Map<ResourceLocation, List<BlockStateModelLoader.LoadedJson>>)p_251281_), p_250550_);
        Map<ResourceLocation, CompletableFuture<AtlasSet.StitchResult>> $$9 = this.atlases.scheduleLoad(p_251134_, this.maxMipmapLevels, p_250550_);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])Stream.concat($$9.values().stream(), Stream.of($$8)).toArray(CompletableFuture[]::new)).thenApplyAsync(arg_0 -> this.lambda$reload$3(p_250336_, $$9, (CompletableFuture)$$8, arg_0), p_250550_)).thenCompose(p_252255_ -> p_252255_.readyForUpload.thenApply(p_251581_ -> p_252255_))).thenCompose(p_249079_::wait)).thenAcceptAsync(p_252252_ -> this.apply((ReloadState)p_252252_, p_252324_), p_249221_);
    }

    private static CompletableFuture<Map<ResourceLocation, BlockModel>> loadBlockModels(ResourceManager p_251361_, Executor p_252189_) {
        return CompletableFuture.supplyAsync(() -> ModelBakery.MODEL_LISTER.listMatchingResources(p_251361_), p_252189_).thenCompose(p_250597_ -> {
            ArrayList<CompletableFuture<Pair>> $$2 = new ArrayList<CompletableFuture<Pair>>(p_250597_.size());
            for (Map.Entry $$3 : p_250597_.entrySet()) {
                $$2.add(CompletableFuture.supplyAsync(() -> {
                    Pair pair;
                    block8: {
                        BufferedReader $$1 = ((Resource)$$3.getValue()).openAsReader();
                        try {
                            pair = Pair.of((Object)((ResourceLocation)$$3.getKey()), (Object)BlockModel.fromStream($$1));
                            if ($$1 == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if ($$1 != null) {
                                    try {
                                        ((Reader)$$1).close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception $$2) {
                                LOGGER.error("Failed to load model {}", $$3.getKey(), (Object)$$2);
                                return null;
                            }
                        }
                        ((Reader)$$1).close();
                    }
                    return pair;
                }, p_252189_));
            }
            return Util.sequence($$2).thenApply(p_250813_ -> p_250813_.stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableMap(Pair::getFirst, Pair::getSecond)));
        });
    }

    private static CompletableFuture<Map<ResourceLocation, List<BlockStateModelLoader.LoadedJson>>> loadBlockStates(ResourceManager p_252084_, Executor p_249943_) {
        return CompletableFuture.supplyAsync(() -> BlockStateModelLoader.BLOCKSTATE_LISTER.listMatchingResourceStacks(p_252084_), p_249943_).thenCompose(p_250744_ -> {
            ArrayList<CompletableFuture<Pair>> $$2 = new ArrayList<CompletableFuture<Pair>>(p_250744_.size());
            for (Map.Entry $$3 : p_250744_.entrySet()) {
                $$2.add(CompletableFuture.supplyAsync(() -> {
                    List $$1 = (List)$$3.getValue();
                    ArrayList<BlockStateModelLoader.LoadedJson> $$2 = new ArrayList<BlockStateModelLoader.LoadedJson>($$1.size());
                    for (Resource $$3 : $$1) {
                        try {
                            BufferedReader $$4 = $$3.openAsReader();
                            try {
                                JsonObject $$5 = GsonHelper.parse($$4);
                                $$2.add(new BlockStateModelLoader.LoadedJson($$3.sourcePackId(), (JsonElement)$$5));
                            }
                            finally {
                                if ($$4 == null) continue;
                                ((Reader)$$4).close();
                            }
                        }
                        catch (Exception $$6) {
                            LOGGER.error("Failed to load blockstate {} from pack {}", new Object[]{$$3.getKey(), $$3.sourcePackId(), $$6});
                        }
                    }
                    return Pair.of((Object)((ResourceLocation)$$3.getKey()), $$2);
                }, p_249943_));
            }
            return Util.sequence($$2).thenApply(p_248966_ -> p_248966_.stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableMap(Pair::getFirst, Pair::getSecond)));
        });
    }

    private ReloadState loadModels(ProfilerFiller p_252136_, Map<ResourceLocation, AtlasSet.StitchResult> p_250646_, ModelBakery p_248945_) {
        p_252136_.push("load");
        p_252136_.popPush("baking");
        HashMultimap $$3 = HashMultimap.create();
        p_248945_.bakeModels((arg_0, arg_1) -> ModelManager.lambda$loadModels$15(p_250646_, (Multimap)$$3, arg_0, arg_1));
        $$3.asMap().forEach((p_352087_, p_252017_) -> LOGGER.warn("Missing textures in model {}:\n{}", p_352087_, (Object)p_252017_.stream().sorted(Material.COMPARATOR).map(p_339314_ -> "    " + String.valueOf(p_339314_.atlasLocation()) + ":" + String.valueOf(p_339314_.texture())).collect(Collectors.joining("\n"))));
        p_252136_.popPush("dispatch");
        Map<ModelResourceLocation, BakedModel> $$4 = p_248945_.getBakedTopLevelModels();
        BakedModel $$5 = $$4.get(ModelBakery.MISSING_MODEL_VARIANT);
        IdentityHashMap<BlockState, BakedModel> $$6 = new IdentityHashMap<BlockState, BakedModel>();
        for (Block $$7 : BuiltInRegistries.BLOCK) {
            $$7.getStateDefinition().getPossibleStates().forEach(p_250633_ -> {
                ResourceLocation $$4 = p_250633_.getBlock().builtInRegistryHolder().key().location();
                BakedModel $$5 = $$4.getOrDefault(BlockModelShaper.stateToModelLocation($$4, p_250633_), $$5);
                $$6.put((BlockState)p_250633_, $$5);
            });
        }
        CompletableFuture<Void> $$8 = CompletableFuture.allOf((CompletableFuture[])p_250646_.values().stream().map(AtlasSet.StitchResult::readyForUpload).toArray(CompletableFuture[]::new));
        p_252136_.pop();
        p_252136_.endTick();
        return new ReloadState(p_248945_, $$5, $$6, p_250646_, $$8);
    }

    private void apply(ReloadState p_248996_, ProfilerFiller p_251960_) {
        p_251960_.startTick();
        p_251960_.push("upload");
        p_248996_.atlasPreparations.values().forEach(AtlasSet.StitchResult::upload);
        ModelBakery $$2 = p_248996_.modelBakery;
        this.bakedRegistry = $$2.getBakedTopLevelModels();
        this.modelGroups = $$2.getModelGroups();
        this.missingModel = p_248996_.missingModel;
        p_251960_.popPush("cache");
        this.blockModelShaper.replaceCache(p_248996_.modelCache);
        p_251960_.pop();
        p_251960_.endTick();
    }

    public boolean requiresRender(BlockState p_119416_, BlockState p_119417_) {
        int $$3;
        if (p_119416_ == p_119417_) {
            return false;
        }
        int $$2 = this.modelGroups.getInt((Object)p_119416_);
        if ($$2 != -1 && $$2 == ($$3 = this.modelGroups.getInt((Object)p_119417_))) {
            FluidState $$5;
            FluidState $$4 = p_119416_.getFluidState();
            return $$4 != ($$5 = p_119417_.getFluidState());
        }
        return true;
    }

    public TextureAtlas getAtlas(ResourceLocation p_119429_) {
        return this.atlases.getAtlas(p_119429_);
    }

    @Override
    public void close() {
        this.atlases.close();
    }

    public void updateMaxMipLevel(int p_119411_) {
        this.maxMipmapLevels = p_119411_;
    }

    private static /* synthetic */ TextureAtlasSprite lambda$loadModels$15(Map p_249446_, Multimap p_249860_, ModelResourceLocation p_352403_, Material p_251262_) {
        AtlasSet.StitchResult $$4 = (AtlasSet.StitchResult)p_249446_.get(p_251262_.atlasLocation());
        TextureAtlasSprite $$5 = $$4.getSprite(p_251262_.texture());
        if ($$5 != null) {
            return $$5;
        }
        p_249860_.put((Object)p_352403_, (Object)p_251262_);
        return $$4.missing();
    }

    private /* synthetic */ ReloadState lambda$reload$3(ProfilerFiller p_251601_, Map p_250226_, CompletableFuture p_251585_, Void p_248624_) {
        return this.loadModels(p_251601_, p_250226_.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, p_248988_ -> (AtlasSet.StitchResult)((CompletableFuture)p_248988_.getValue()).join())), (ModelBakery)p_251585_.join());
    }

    record ReloadState(ModelBakery modelBakery, BakedModel missingModel, Map<BlockState, BakedModel> modelCache, Map<ResourceLocation, AtlasSet.StitchResult> atlasPreparations, CompletableFuture<Void> readyForUpload) {
    }
}

