/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;

public interface PlainTextContents
extends ComponentContents {
    public static final MapCodec<PlainTextContents> CODEC = RecordCodecBuilder.mapCodec(p_304480_ -> p_304480_.group((App)Codec.STRING.fieldOf("text").forGetter(PlainTextContents::text)).apply((Applicative)p_304480_, PlainTextContents::create));
    public static final ComponentContents.Type<PlainTextContents> TYPE = new ComponentContents.Type<PlainTextContents>(CODEC, "text");
    public static final PlainTextContents EMPTY = new PlainTextContents(){

        public String toString() {
            return "empty";
        }

        @Override
        public String text() {
            return "";
        }
    };

    public static PlainTextContents create(String p_304441_) {
        return p_304441_.isEmpty() ? EMPTY : new LiteralContents(p_304441_);
    }

    public String text();

    @Override
    default public ComponentContents.Type<?> type() {
        return TYPE;
    }

    public record LiteralContents(String text) implements PlainTextContents
    {
        @Override
        public <T> Optional<T> visit(FormattedText.ContentConsumer<T> p_304816_) {
            return p_304816_.accept(this.text);
        }

        @Override
        public <T> Optional<T> visit(FormattedText.StyledContentConsumer<T> p_304890_, Style p_304907_) {
            return p_304890_.accept(p_304907_, this.text);
        }

        @Override
        public String toString() {
            return "literal{" + this.text + "}";
        }
    }
}

