/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.pathfinder.Path;
import org.apache.commons.lang3.mutable.MutableLong;

public class AcquirePoi {
    public static final int SCAN_RANGE = 48;

    public static BehaviorControl<PathfinderMob> create(Predicate<Holder<PoiType>> p_259994_, MemoryModuleType<GlobalPos> p_259167_, boolean p_259077_, Optional<Byte> p_259824_) {
        return AcquirePoi.create(p_259994_, p_259167_, p_259167_, p_259077_, p_259824_);
    }

    public static BehaviorControl<PathfinderMob> create(Predicate<Holder<PoiType>> p_260007_, MemoryModuleType<GlobalPos> p_259129_, MemoryModuleType<GlobalPos> p_260194_, boolean p_259108_, Optional<Byte> p_260129_) {
        int $$5 = 5;
        int $$6 = 20;
        MutableLong $$7 = new MutableLong(0L);
        Long2ObjectOpenHashMap $$8 = new Long2ObjectOpenHashMap();
        OneShot<PathfinderMob> $$9 = BehaviorBuilder.create(arg_0 -> AcquirePoi.lambda$create$8(p_260194_, p_259108_, $$7, (Long2ObjectMap)$$8, p_260007_, p_260129_, arg_0));
        if (p_260194_ == p_259129_) {
            return $$9;
        }
        return BehaviorBuilder.create(p_258269_ -> p_258269_.group(p_258269_.absent(p_259129_)).apply((Applicative)p_258269_, p_258302_ -> $$9));
    }

    @Nullable
    public static Path findPathToPois(Mob p_217098_, Set<Pair<Holder<PoiType>, BlockPos>> p_217099_) {
        if (p_217099_.isEmpty()) {
            return null;
        }
        HashSet<BlockPos> $$2 = new HashSet<BlockPos>();
        int $$3 = 1;
        for (Pair<Holder<PoiType>, BlockPos> $$4 : p_217099_) {
            $$3 = Math.max($$3, ((PoiType)((Holder)$$4.getFirst()).value()).validRange());
            $$2.add((BlockPos)$$4.getSecond());
        }
        return p_217098_.getNavigation().createPath($$2, $$3);
    }

    private static /* synthetic */ App lambda$create$8(MemoryModuleType p_258270_, boolean p_258271_, MutableLong p_258272_, Long2ObjectMap p_258273_, Predicate p_258274_, Optional p_258275_, BehaviorBuilder.Instance p_258276_) {
        return p_258276_.group(p_258276_.absent(p_258270_)).apply((Applicative)p_258276_, p_258300_ -> (p_258292_, p_258293_, p_258294_) -> {
            if (p_258271_ && p_258293_.isBaby()) {
                return false;
            }
            if (p_258272_.getValue() == 0L) {
                p_258272_.setValue(p_258292_.getGameTime() + (long)p_258292_.random.nextInt(20));
                return false;
            }
            if (p_258292_.getGameTime() < p_258272_.getValue()) {
                return false;
            }
            p_258272_.setValue(p_258294_ + 20L + (long)p_258292_.getRandom().nextInt(20));
            PoiManager $$9 = p_258292_.getPoiManager();
            p_258273_.long2ObjectEntrySet().removeIf(p_22338_ -> !((JitteredLinearRetry)p_22338_.getValue()).isStillValid(p_258294_));
            Predicate<BlockPos> $$10 = p_258266_ -> {
                JitteredLinearRetry $$3 = (JitteredLinearRetry)p_258273_.get(p_258266_.asLong());
                if ($$3 == null) {
                    return true;
                }
                if (!$$3.shouldRetry(p_258294_)) {
                    return false;
                }
                $$3.markAttempt(p_258294_);
                return true;
            };
            Set<Pair<Holder<PoiType>, BlockPos>> $$11 = $$9.findAllClosestFirstWithType(p_258274_, $$10, p_258293_.blockPosition(), 48, PoiManager.Occupancy.HAS_SPACE).limit(5L).collect(Collectors.toSet());
            Path $$12 = AcquirePoi.findPathToPois(p_258293_, $$11);
            if ($$12 != null && $$12.canReach()) {
                BlockPos $$13 = $$12.getTarget();
                $$9.getType($$13).ifPresent(p_340720_ -> {
                    $$9.take(p_258274_, (p_217108_, p_217109_) -> p_217109_.equals($$13), $$13, 1);
                    p_258300_.set(GlobalPos.of(p_258292_.dimension(), $$13));
                    p_258275_.ifPresent(p_147369_ -> p_258292_.broadcastEntityEvent(p_258293_, (byte)p_147369_));
                    p_258273_.clear();
                    DebugPackets.sendPoiTicketCountPacket(p_258292_, $$13);
                });
            } else {
                for (Pair<Holder<PoiType>, BlockPos> $$14 : $$11) {
                    p_258273_.computeIfAbsent(((BlockPos)$$14.getSecond()).asLong(), p_264881_ -> new JitteredLinearRetry(p_264879_.random, p_258294_));
                }
            }
            return true;
        });
    }

    static class JitteredLinearRetry {
        private static final int MIN_INTERVAL_INCREASE = 40;
        private static final int MAX_INTERVAL_INCREASE = 80;
        private static final int MAX_RETRY_PATHFINDING_INTERVAL = 400;
        private final RandomSource random;
        private long previousAttemptTimestamp;
        private long nextScheduledAttemptTimestamp;
        private int currentDelay;

        JitteredLinearRetry(RandomSource p_217111_, long p_217112_) {
            this.random = p_217111_;
            this.markAttempt(p_217112_);
        }

        public void markAttempt(long p_22381_) {
            this.previousAttemptTimestamp = p_22381_;
            int $$1 = this.currentDelay + this.random.nextInt(40) + 40;
            this.currentDelay = Math.min($$1, 400);
            this.nextScheduledAttemptTimestamp = p_22381_ + (long)this.currentDelay;
        }

        public boolean isStillValid(long p_22383_) {
            return p_22383_ - this.previousAttemptTimestamp < 400L;
        }

        public boolean shouldRetry(long p_22385_) {
            return p_22385_ >= this.nextScheduledAttemptTimestamp;
        }

        public String toString() {
            return "RetryMarker{, previousAttemptAt=" + this.previousAttemptTimestamp + ", nextScheduledAttemptAt=" + this.nextScheduledAttemptTimestamp + ", currentDelay=" + this.currentDelay + "}";
        }
    }
}

