/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Explosion {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new ExplosionDamageCalculator();
    private static final int MAX_DROPS_PER_COMBINED_STACK = 16;
    private final boolean fire;
    private final BlockInteraction blockInteraction;
    private final RandomSource random = RandomSource.create();
    private final Level level;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    private final Entity source;
    private final float radius;
    private final DamageSource damageSource;
    private final ExplosionDamageCalculator damageCalculator;
    private final ParticleOptions smallExplosionParticles;
    private final ParticleOptions largeExplosionParticles;
    private final Holder<SoundEvent> explosionSound;
    private final ObjectArrayList<BlockPos> toBlow = new ObjectArrayList();
    private final Map<Player, Vec3> hitPlayers = Maps.newHashMap();

    public static DamageSource getDefaultDamageSource(Level p_312716_, @Nullable Entity p_312608_) {
        return p_312716_.damageSources().explosion(p_312608_, Explosion.getIndirectSourceEntityInternal(p_312608_));
    }

    public Explosion(Level p_46051_, @Nullable Entity p_46052_, double p_46055_, double p_46056_, double p_46057_, float p_46058_, List<BlockPos> p_312600_, BlockInteraction p_46060_, ParticleOptions p_312560_, ParticleOptions p_312844_, Holder<SoundEvent> p_320054_) {
        this(p_46051_, p_46052_, Explosion.getDefaultDamageSource(p_46051_, p_46052_), null, p_46055_, p_46056_, p_46057_, p_46058_, false, p_46060_, p_312560_, p_312844_, p_320054_);
        this.toBlow.addAll(p_312600_);
    }

    public Explosion(Level p_46041_, @Nullable Entity p_46042_, double p_46043_, double p_46044_, double p_46045_, float p_46046_, boolean p_46047_, BlockInteraction p_46048_, List<BlockPos> p_46049_) {
        this(p_46041_, p_46042_, p_46043_, p_46044_, p_46045_, p_46046_, p_46047_, p_46048_);
        this.toBlow.addAll(p_46049_);
    }

    public Explosion(Level p_46032_, @Nullable Entity p_46033_, double p_46034_, double p_46035_, double p_46036_, float p_46037_, boolean p_46038_, BlockInteraction p_46039_) {
        this(p_46032_, p_46033_, Explosion.getDefaultDamageSource(p_46032_, p_46033_), null, p_46034_, p_46035_, p_46036_, p_46037_, p_46038_, p_46039_, ParticleTypes.EXPLOSION, ParticleTypes.EXPLOSION_EMITTER, SoundEvents.GENERIC_EXPLODE);
    }

    public Explosion(Level p_46024_, @Nullable Entity p_46025_, @Nullable DamageSource p_312268_, @Nullable ExplosionDamageCalculator p_312205_, double p_46026_, double p_46027_, double p_46028_, float p_46029_, boolean p_312333_, BlockInteraction p_312294_, ParticleOptions p_312158_, ParticleOptions p_311904_, Holder<SoundEvent> p_320270_) {
        this.level = p_46024_;
        this.source = p_46025_;
        this.radius = p_46029_;
        this.x = p_46026_;
        this.y = p_46027_;
        this.z = p_46028_;
        this.fire = p_312333_;
        this.blockInteraction = p_312294_;
        this.damageSource = p_312268_ == null ? p_46024_.damageSources().explosion(this) : p_312268_;
        this.damageCalculator = p_312205_ == null ? this.makeDamageCalculator(p_46025_) : p_312205_;
        this.smallExplosionParticles = p_312158_;
        this.largeExplosionParticles = p_311904_;
        this.explosionSound = p_320270_;
    }

    private ExplosionDamageCalculator makeDamageCalculator(@Nullable Entity p_46063_) {
        return p_46063_ == null ? EXPLOSION_DAMAGE_CALCULATOR : new EntityBasedExplosionDamageCalculator(p_46063_);
    }

    public static float getSeenPercent(Vec3 p_46065_, Entity p_46066_) {
        AABB $$2 = p_46066_.getBoundingBox();
        double $$3 = 1.0 / (($$2.maxX - $$2.minX) * 2.0 + 1.0);
        double $$4 = 1.0 / (($$2.maxY - $$2.minY) * 2.0 + 1.0);
        double $$5 = 1.0 / (($$2.maxZ - $$2.minZ) * 2.0 + 1.0);
        double $$6 = (1.0 - Math.floor(1.0 / $$3) * $$3) / 2.0;
        double $$7 = (1.0 - Math.floor(1.0 / $$5) * $$5) / 2.0;
        if ($$3 < 0.0 || $$4 < 0.0 || $$5 < 0.0) {
            return 0.0f;
        }
        int $$8 = 0;
        int $$9 = 0;
        for (double $$10 = 0.0; $$10 <= 1.0; $$10 += $$3) {
            for (double $$11 = 0.0; $$11 <= 1.0; $$11 += $$4) {
                for (double $$12 = 0.0; $$12 <= 1.0; $$12 += $$5) {
                    double $$13 = Mth.lerp($$10, $$2.minX, $$2.maxX);
                    double $$14 = Mth.lerp($$11, $$2.minY, $$2.maxY);
                    double $$15 = Mth.lerp($$12, $$2.minZ, $$2.maxZ);
                    Vec3 $$16 = new Vec3($$13 + $$6, $$14, $$15 + $$7);
                    if (p_46066_.level().clip(new ClipContext($$16, p_46065_, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, p_46066_)).getType() == HitResult.Type.MISS) {
                        ++$$8;
                    }
                    ++$$9;
                }
            }
        }
        return (float)$$8 / (float)$$9;
    }

    public float radius() {
        return this.radius;
    }

    public Vec3 center() {
        return new Vec3(this.x, this.y, this.z);
    }

    public void explode() {
        this.level.gameEvent(this.source, GameEvent.EXPLODE, new Vec3(this.x, this.y, this.z));
        HashSet $$0 = Sets.newHashSet();
        int $$1 = 16;
        for (int $$2 = 0; $$2 < 16; ++$$2) {
            for (int $$3 = 0; $$3 < 16; ++$$3) {
                block2: for (int $$4 = 0; $$4 < 16; ++$$4) {
                    if ($$2 != 0 && $$2 != 15 && $$3 != 0 && $$3 != 15 && $$4 != 0 && $$4 != 15) continue;
                    double $$5 = (float)$$2 / 15.0f * 2.0f - 1.0f;
                    double $$6 = (float)$$3 / 15.0f * 2.0f - 1.0f;
                    double $$7 = (float)$$4 / 15.0f * 2.0f - 1.0f;
                    double $$8 = Math.sqrt($$5 * $$5 + $$6 * $$6 + $$7 * $$7);
                    $$5 /= $$8;
                    $$6 /= $$8;
                    $$7 /= $$8;
                    double $$10 = this.x;
                    double $$11 = this.y;
                    double $$12 = this.z;
                    float $$13 = 0.3f;
                    for (float $$9 = this.radius * (0.7f + this.level.random.nextFloat() * 0.6f); $$9 > 0.0f; $$9 -= 0.22500001f) {
                        BlockPos $$14 = BlockPos.containing($$10, $$11, $$12);
                        BlockState $$15 = this.level.getBlockState($$14);
                        FluidState $$16 = this.level.getFluidState($$14);
                        if (!this.level.isInWorldBounds($$14)) continue block2;
                        Optional<Float> $$17 = this.damageCalculator.getBlockExplosionResistance(this, this.level, $$14, $$15, $$16);
                        if ($$17.isPresent()) {
                            $$9 -= ($$17.get().floatValue() + 0.3f) * 0.3f;
                        }
                        if ($$9 > 0.0f && this.damageCalculator.shouldBlockExplode(this, this.level, $$14, $$15, $$9)) {
                            $$0.add($$14);
                        }
                        $$10 += $$5 * (double)0.3f;
                        $$11 += $$6 * (double)0.3f;
                        $$12 += $$7 * (double)0.3f;
                    }
                }
            }
        }
        this.toBlow.addAll((Collection)$$0);
        float $$18 = this.radius * 2.0f;
        int $$19 = Mth.floor(this.x - (double)$$18 - 1.0);
        int $$20 = Mth.floor(this.x + (double)$$18 + 1.0);
        int $$21 = Mth.floor(this.y - (double)$$18 - 1.0);
        int $$22 = Mth.floor(this.y + (double)$$18 + 1.0);
        int $$23 = Mth.floor(this.z - (double)$$18 - 1.0);
        int $$24 = Mth.floor(this.z + (double)$$18 + 1.0);
        List<Entity> $$25 = this.level.getEntities(this.source, new AABB($$19, $$21, $$23, $$20, $$22, $$24));
        Vec3 $$26 = new Vec3(this.x, this.y, this.z);
        for (Entity $$27 : $$25) {
            Player $$38;
            double $$36;
            double $$31;
            double $$30;
            double $$29;
            double $$32;
            double $$28;
            if ($$27.ignoreExplosion(this) || !(($$28 = Math.sqrt($$27.distanceToSqr($$26)) / (double)$$18) <= 1.0) || ($$32 = Math.sqrt(($$29 = $$27.getX() - this.x) * $$29 + ($$30 = ($$27 instanceof PrimedTnt ? $$27.getY() : $$27.getEyeY()) - this.y) * $$30 + ($$31 = $$27.getZ() - this.z) * $$31)) == 0.0) continue;
            $$29 /= $$32;
            $$30 /= $$32;
            $$31 /= $$32;
            if (this.damageCalculator.shouldDamageEntity(this, $$27)) {
                $$27.hurt(this.damageSource, this.damageCalculator.getEntityDamageAmount(this, $$27));
            }
            double $$33 = (1.0 - $$28) * (double)Explosion.getSeenPercent($$26, $$27) * (double)this.damageCalculator.getKnockbackMultiplier($$27);
            if ($$27 instanceof LivingEntity) {
                LivingEntity $$34 = (LivingEntity)$$27;
                double $$35 = $$33 * (1.0 - $$34.getAttributeValue(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE));
            } else {
                $$36 = $$33;
            }
            Vec3 $$37 = new Vec3($$29 *= $$36, $$30 *= $$36, $$31 *= $$36);
            $$27.setDeltaMovement($$27.getDeltaMovement().add($$37));
            if (!(!($$27 instanceof Player) || ($$38 = (Player)$$27).isSpectator() || $$38.isCreative() && $$38.getAbilities().flying)) {
                this.hitPlayers.put($$38, $$37);
            }
            $$27.onExplosionHit(this.source);
        }
    }

    public void finalizeExplosion(boolean p_46076_) {
        if (this.level.isClientSide) {
            this.level.playLocalSound(this.x, this.y, this.z, this.explosionSound.value(), SoundSource.BLOCKS, 4.0f, (1.0f + (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f) * 0.7f, false);
        }
        boolean $$1 = this.interactsWithBlocks();
        if (p_46076_) {
            ParticleOptions $$3;
            if (this.radius < 2.0f || !$$1) {
                ParticleOptions $$2 = this.smallExplosionParticles;
            } else {
                $$3 = this.largeExplosionParticles;
            }
            this.level.addParticle($$3, this.x, this.y, this.z, 1.0, 0.0, 0.0);
        }
        if ($$1) {
            this.level.getProfiler().push("explosion_blocks");
            ArrayList $$4 = new ArrayList();
            Util.shuffle(this.toBlow, this.level.random);
            for (BlockPos $$5 : this.toBlow) {
                this.level.getBlockState($$5).onExplosionHit(this.level, $$5, this, (p_311741_, p_311742_) -> Explosion.addOrAppendStack($$4, p_311741_, p_311742_));
            }
            for (Pair $$6 : $$4) {
                Block.popResource(this.level, (BlockPos)$$6.getSecond(), (ItemStack)$$6.getFirst());
            }
            this.level.getProfiler().pop();
        }
        if (this.fire) {
            for (BlockPos $$7 : this.toBlow) {
                if (this.random.nextInt(3) != 0 || !this.level.getBlockState($$7).isAir() || !this.level.getBlockState($$7.below()).isSolidRender(this.level, $$7.below())) continue;
                this.level.setBlockAndUpdate($$7, BaseFireBlock.getState(this.level, $$7));
            }
        }
    }

    private static void addOrAppendStack(List<Pair<ItemStack, BlockPos>> p_312455_, ItemStack p_312913_, BlockPos p_312738_) {
        for (int $$3 = 0; $$3 < p_312455_.size(); ++$$3) {
            Pair<ItemStack, BlockPos> $$4 = p_312455_.get($$3);
            ItemStack $$5 = (ItemStack)$$4.getFirst();
            if (!ItemEntity.areMergable($$5, p_312913_)) continue;
            p_312455_.set($$3, (Pair<ItemStack, BlockPos>)Pair.of((Object)ItemEntity.merge($$5, p_312913_, 16), (Object)((BlockPos)$$4.getSecond())));
            if (!p_312913_.isEmpty()) continue;
            return;
        }
        p_312455_.add((Pair<ItemStack, BlockPos>)Pair.of((Object)p_312913_, (Object)p_312738_));
    }

    public boolean interactsWithBlocks() {
        return this.blockInteraction != BlockInteraction.KEEP;
    }

    public Map<Player, Vec3> getHitPlayers() {
        return this.hitPlayers;
    }

    @Nullable
    private static LivingEntity getIndirectSourceEntityInternal(@Nullable Entity p_312444_) {
        Projectile $$3;
        Entity $$4;
        if (p_312444_ == null) {
            return null;
        }
        if (p_312444_ instanceof PrimedTnt) {
            PrimedTnt $$1 = (PrimedTnt)p_312444_;
            return $$1.getOwner();
        }
        if (p_312444_ instanceof LivingEntity) {
            LivingEntity $$2 = (LivingEntity)p_312444_;
            return $$2;
        }
        if (p_312444_ instanceof Projectile && ($$4 = ($$3 = (Projectile)p_312444_).getOwner()) instanceof LivingEntity) {
            LivingEntity $$5 = (LivingEntity)$$4;
            return $$5;
        }
        return null;
    }

    @Nullable
    public LivingEntity getIndirectSourceEntity() {
        return Explosion.getIndirectSourceEntityInternal(this.source);
    }

    @Nullable
    public Entity getDirectSourceEntity() {
        return this.source;
    }

    public void clearToBlow() {
        this.toBlow.clear();
    }

    public List<BlockPos> getToBlow() {
        return this.toBlow;
    }

    public BlockInteraction getBlockInteraction() {
        return this.blockInteraction;
    }

    public ParticleOptions getSmallExplosionParticles() {
        return this.smallExplosionParticles;
    }

    public ParticleOptions getLargeExplosionParticles() {
        return this.largeExplosionParticles;
    }

    public Holder<SoundEvent> getExplosionSound() {
        return this.explosionSound;
    }

    public boolean canTriggerBlocks() {
        if (this.blockInteraction != BlockInteraction.TRIGGER_BLOCK || this.level.isClientSide()) {
            return false;
        }
        if (this.source != null && this.source.getType() == EntityType.BREEZE_WIND_CHARGE) {
            return this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
        }
        return true;
    }

    public static enum BlockInteraction {
        KEEP,
        DESTROY,
        DESTROY_WITH_DECAY,
        TRIGGER_BLOCK;

    }
}

