/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import it.unimi.dsi.fastutil.HashCommon;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import org.jetbrains.annotations.Nullable;

public class PathTypeCache {
    private static final int SIZE = 4096;
    private static final int MASK = 4095;
    private final long[] positions = new long[4096];
    private final PathType[] pathTypes = new PathType[4096];

    public PathType getOrCompute(BlockGetter p_330930_, BlockPos p_331162_) {
        long $$2 = p_331162_.asLong();
        int $$3 = PathTypeCache.index($$2);
        PathType $$4 = this.get($$3, $$2);
        if ($$4 != null) {
            return $$4;
        }
        return this.compute(p_330930_, p_331162_, $$3, $$2);
    }

    @Nullable
    private PathType get(int p_330588_, long p_331771_) {
        if (this.positions[p_330588_] == p_331771_) {
            return this.pathTypes[p_330588_];
        }
        return null;
    }

    private PathType compute(BlockGetter p_330773_, BlockPos p_330311_, int p_330671_, long p_332065_) {
        PathType $$4 = WalkNodeEvaluator.getPathTypeFromState(p_330773_, p_330311_);
        this.positions[p_330671_] = p_332065_;
        this.pathTypes[p_330671_] = $$4;
        return $$4;
    }

    public void invalidate(BlockPos p_331507_) {
        long $$1 = p_331507_.asLong();
        int $$2 = PathTypeCache.index($$1);
        if (this.positions[$$2] == $$1) {
            this.pathTypes[$$2] = null;
        }
    }

    private static int index(long p_332203_) {
        return (int)HashCommon.mix((long)p_332203_) & 0xFFF;
    }
}

