/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTicks;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.ChunkDataEvent;
import org.slf4j.Logger;

public class ChunkSerializer {
    private static final Codec<PalettedContainer<BlockState>> BLOCK_STATE_CODEC = PalettedContainer.codecRW(Block.BLOCK_STATE_REGISTRY, BlockState.CODEC, PalettedContainer.Strategy.SECTION_STATES, Blocks.AIR.defaultBlockState());
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG = "block_ticks";
    private static final String FLUID_TICKS_TAG = "fluid_ticks";
    public static final String X_POS_TAG = "xPos";
    public static final String Z_POS_TAG = "zPos";
    public static final String HEIGHTMAPS_TAG = "Heightmaps";
    public static final String IS_LIGHT_ON_TAG = "isLightOn";
    public static final String SECTIONS_TAG = "sections";
    public static final String BLOCK_LIGHT_TAG = "BlockLight";
    public static final String SKY_LIGHT_TAG = "SkyLight";

    public static ProtoChunk read(ServerLevel p_188231_, PoiManager p_188232_, RegionStorageInfo p_352213_, ChunkPos p_188233_, CompoundTag p_188234_) {
        Object chunkaccess;
        ChunkPos chunkpos = new ChunkPos(p_188234_.getInt(X_POS_TAG), p_188234_.getInt(Z_POS_TAG));
        if (!Objects.equals(p_188233_, chunkpos)) {
            LOGGER.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", new Object[]{p_188233_, p_188233_, chunkpos});
            p_188231_.getServer().reportMisplacedChunk(chunkpos, p_188233_, p_352213_);
        }
        UpgradeData upgradedata = p_188234_.contains(TAG_UPGRADE_DATA, 10) ? new UpgradeData(p_188234_.getCompound(TAG_UPGRADE_DATA), (LevelHeightAccessor)p_188231_) : UpgradeData.EMPTY;
        boolean flag = p_188234_.getBoolean(IS_LIGHT_ON_TAG);
        ListTag listtag = p_188234_.getList(SECTIONS_TAG, 10);
        int i = p_188231_.getSectionsCount();
        LevelChunkSection[] alevelchunksection = new LevelChunkSection[i];
        boolean flag1 = p_188231_.dimensionType().hasSkyLight();
        ServerChunkCache chunksource = p_188231_.getChunkSource();
        LevelLightEngine levellightengine = chunksource.getLightEngine();
        Registry registry = p_188231_.registryAccess().registryOrThrow(Registries.BIOME);
        Codec<PalettedContainerRO<Holder<Biome>>> codec = ChunkSerializer.makeBiomeCodec(registry);
        boolean flag2 = false;
        for (int j = 0; j < listtag.size(); ++j) {
            boolean flag4;
            CompoundTag compoundtag = listtag.getCompound(j);
            byte k = compoundtag.getByte("Y");
            int l = p_188231_.getSectionIndexFromSectionY(k);
            if (l >= 0 && l < alevelchunksection.length) {
                LevelChunkSection levelchunksection;
                PalettedContainer palettedcontainer = compoundtag.contains("block_states", 10) ? (PalettedContainer)BLOCK_STATE_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundtag.getCompound("block_states")).promotePartial(p_188283_ -> ChunkSerializer.logErrors(p_188233_, k, p_188283_)).getOrThrow(ChunkReadException::new) : new PalettedContainer(Block.BLOCK_STATE_REGISTRY, Blocks.AIR.defaultBlockState(), PalettedContainer.Strategy.SECTION_STATES);
                PalettedContainerRO palettedcontainerro = compoundtag.contains("biomes", 10) ? (PalettedContainerRO)codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundtag.getCompound("biomes")).promotePartial(p_188274_ -> ChunkSerializer.logErrors(p_188233_, k, p_188274_)).getOrThrow(ChunkReadException::new) : new PalettedContainer(registry.asHolderIdMap(), registry.getHolderOrThrow(Biomes.PLAINS), PalettedContainer.Strategy.SECTION_BIOMES);
                alevelchunksection[l] = levelchunksection = new LevelChunkSection(palettedcontainer, (PalettedContainerRO<Holder<Biome>>)palettedcontainerro);
                SectionPos sectionpos = SectionPos.of((ChunkPos)p_188233_, (int)k);
                p_188232_.checkConsistencyWithBlocks(sectionpos, levelchunksection);
            }
            boolean flag3 = compoundtag.contains(BLOCK_LIGHT_TAG, 7);
            boolean bl = flag4 = flag1 && compoundtag.contains(SKY_LIGHT_TAG, 7);
            if (!flag3 && !flag4) continue;
            if (!flag2) {
                levellightengine.retainData(p_188233_, true);
                flag2 = true;
            }
            if (flag3) {
                levellightengine.queueSectionData(LightLayer.BLOCK, SectionPos.of((ChunkPos)p_188233_, (int)k), new DataLayer(compoundtag.getByteArray(BLOCK_LIGHT_TAG)));
            }
            if (!flag4) continue;
            levellightengine.queueSectionData(LightLayer.SKY, SectionPos.of((ChunkPos)p_188233_, (int)k), new DataLayer(compoundtag.getByteArray(SKY_LIGHT_TAG)));
        }
        long k1 = p_188234_.getLong("InhabitedTime");
        ChunkType chunktype = ChunkSerializer.getChunkTypeFromTag(p_188234_);
        BlendingData blendingdata = p_188234_.contains("blending_data", 10) ? (BlendingData)BlendingData.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)p_188234_.getCompound("blending_data"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null) : null;
        if (chunktype == ChunkType.LEVELCHUNK) {
            LevelChunkTicks levelchunkticks = LevelChunkTicks.load((ListTag)p_188234_.getList(BLOCK_TICKS_TAG, 10), p_258988_ -> BuiltInRegistries.BLOCK.getOptional(ResourceLocation.tryParse(p_258988_)), (ChunkPos)p_188233_);
            LevelChunkTicks levelchunkticks1 = LevelChunkTicks.load((ListTag)p_188234_.getList(FLUID_TICKS_TAG, 10), p_258990_ -> BuiltInRegistries.FLUID.getOptional(ResourceLocation.tryParse(p_258990_)), (ChunkPos)p_188233_);
            chunkaccess = new LevelChunk(p_188231_.getLevel(), p_188233_, upgradedata, (LevelChunkTicks<Block>)levelchunkticks, (LevelChunkTicks<Fluid>)levelchunkticks1, k1, alevelchunksection, ChunkSerializer.postLoadChunk(p_188231_, p_188234_), blendingdata);
            if (p_188234_.contains("neoforge:aux_lights", 9)) {
                Objects.requireNonNull(((LevelChunk)chunkaccess).getAuxLightManager(p_188233_)).deserializeNBT((HolderLookup.Provider)p_188231_.registryAccess(), p_188234_.getList("neoforge:aux_lights", 10));
            }
        } else {
            Object protochunk;
            ProtoChunkTicks protochunkticks = ProtoChunkTicks.load((ListTag)p_188234_.getList(BLOCK_TICKS_TAG, 10), p_258992_ -> BuiltInRegistries.BLOCK.getOptional(ResourceLocation.tryParse(p_258992_)), (ChunkPos)p_188233_);
            ProtoChunkTicks protochunkticks1 = ProtoChunkTicks.load((ListTag)p_188234_.getList(FLUID_TICKS_TAG, 10), p_258991_ -> BuiltInRegistries.FLUID.getOptional(ResourceLocation.tryParse(p_258991_)), (ChunkPos)p_188233_);
            chunkaccess = protochunk = new ProtoChunk(p_188233_, upgradedata, alevelchunksection, protochunkticks, protochunkticks1, (LevelHeightAccessor)p_188231_, registry, blendingdata);
            protochunk.setInhabitedTime(k1);
            if (p_188234_.contains("below_zero_retrogen", 10)) {
                BelowZeroRetrogen.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)p_188234_.getCompound("below_zero_retrogen"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(arg_0 -> ((ProtoChunk)protochunk).setBelowZeroRetrogen(arg_0));
            }
            ChunkStatus chunkstatus = ChunkStatus.byName((String)p_188234_.getString("Status"));
            protochunk.setPersistedStatus(chunkstatus);
            if (chunkstatus.isOrAfter(ChunkStatus.INITIALIZE_LIGHT)) {
                protochunk.setLightEngine(levellightengine);
            }
        }
        if (p_188234_.contains("neoforge:attachments", 10)) {
            ((ChunkAccess)chunkaccess).readAttachmentsFromNBT((HolderLookup.Provider)p_188231_.registryAccess(), p_188234_.getCompound("neoforge:attachments"));
        }
        ((ChunkAccess)chunkaccess).setLightCorrect(flag);
        CompoundTag compoundtag2 = p_188234_.getCompound(HEIGHTMAPS_TAG);
        EnumSet<Heightmap.Types> enumset = EnumSet.noneOf(Heightmap.Types.class);
        for (Heightmap.Types heightmap$types : ((ChunkAccess)chunkaccess).getPersistedStatus().heightmapsAfter()) {
            String s = heightmap$types.getSerializationKey();
            if (compoundtag2.contains(s, 12)) {
                ((ChunkAccess)chunkaccess).setHeightmap(heightmap$types, compoundtag2.getLongArray(s));
                continue;
            }
            enumset.add(heightmap$types);
        }
        Heightmap.primeHeightmaps((ChunkAccess)chunkaccess, enumset);
        CompoundTag compoundtag3 = p_188234_.getCompound("structures");
        ((ChunkAccess)chunkaccess).setAllStarts(ChunkSerializer.unpackStructureStart(StructurePieceSerializationContext.fromLevel((ServerLevel)p_188231_), compoundtag3, p_188231_.getSeed()));
        ((ChunkAccess)chunkaccess).setAllReferences(ChunkSerializer.unpackStructureReferences(p_188231_.registryAccess(), p_188233_, compoundtag3));
        if (p_188234_.getBoolean("shouldSave")) {
            ((ChunkAccess)chunkaccess).setUnsaved(true);
        }
        ListTag listtag2 = p_188234_.getList("PostProcessing", 9);
        for (int l1 = 0; l1 < listtag2.size(); ++l1) {
            ListTag listtag1 = listtag2.getList(l1);
            for (int i1 = 0; i1 < listtag1.size(); ++i1) {
                ((ChunkAccess)chunkaccess).addPackedPostProcess(listtag1.getShort(i1), l1);
            }
        }
        if (chunktype == ChunkType.LEVELCHUNK) {
            NeoForge.EVENT_BUS.post((Event)new ChunkDataEvent.Load((ChunkAccess)chunkaccess, p_188234_, chunktype));
            return new ImposterProtoChunk((LevelChunk)chunkaccess, false);
        }
        ProtoChunk protochunk1 = (ProtoChunk)chunkaccess;
        ListTag listtag3 = p_188234_.getList("entities", 10);
        for (int i2 = 0; i2 < listtag3.size(); ++i2) {
            protochunk1.addEntity(listtag3.getCompound(i2));
        }
        ListTag listtag4 = p_188234_.getList("block_entities", 10);
        for (int j1 = 0; j1 < listtag4.size(); ++j1) {
            CompoundTag compoundtag1 = listtag4.getCompound(j1);
            ((ChunkAccess)chunkaccess).setBlockEntityNbt(compoundtag1);
        }
        CompoundTag compoundtag4 = p_188234_.getCompound("CarvingMasks");
        for (String s1 : compoundtag4.getAllKeys()) {
            GenerationStep.Carving generationstep$carving = GenerationStep.Carving.valueOf((String)s1);
            protochunk1.setCarvingMask(generationstep$carving, new CarvingMask(compoundtag4.getLongArray(s1), ((ChunkAccess)chunkaccess).getMinBuildHeight()));
        }
        NeoForge.EVENT_BUS.post((Event)new ChunkDataEvent.Load((ChunkAccess)chunkaccess, p_188234_, chunktype));
        return protochunk1;
    }

    private static void logErrors(ChunkPos p_188240_, int p_188241_, String p_188242_) {
        LOGGER.error("Recoverable errors when loading section [{}, {}, {}]: {}", new Object[]{p_188240_.x, p_188241_, p_188240_.z, p_188242_});
    }

    private static Codec<PalettedContainerRO<Holder<Biome>>> makeBiomeCodec(Registry<Biome> p_188261_) {
        return PalettedContainer.codecRO(p_188261_.asHolderIdMap(), p_188261_.holderByNameCodec(), PalettedContainer.Strategy.SECTION_BIOMES, p_188261_.getHolderOrThrow(Biomes.PLAINS));
    }

    public static CompoundTag write(ServerLevel p_63455_, ChunkAccess p_63456_) {
        LevelChunk levelChunk;
        ListTag lightTag;
        UpgradeData upgradedata;
        BelowZeroRetrogen belowzeroretrogen;
        ChunkPos chunkpos = p_63456_.getPos();
        CompoundTag compoundtag = NbtUtils.addCurrentDataVersion((CompoundTag)new CompoundTag());
        compoundtag.putInt(X_POS_TAG, chunkpos.x);
        compoundtag.putInt("yPos", p_63456_.getMinSection());
        compoundtag.putInt(Z_POS_TAG, chunkpos.z);
        compoundtag.putLong("LastUpdate", p_63455_.getGameTime());
        compoundtag.putLong("InhabitedTime", p_63456_.getInhabitedTime());
        compoundtag.putString("Status", BuiltInRegistries.CHUNK_STATUS.getKey((Object)p_63456_.getPersistedStatus()).toString());
        BlendingData blendingdata = p_63456_.getBlendingData();
        if (blendingdata != null) {
            BlendingData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)blendingdata).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_196909_ -> compoundtag.put("blending_data", (Tag)p_196909_));
        }
        if ((belowzeroretrogen = p_63456_.getBelowZeroRetrogen()) != null) {
            BelowZeroRetrogen.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)belowzeroretrogen).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_188279_ -> compoundtag.put("below_zero_retrogen", (Tag)p_188279_));
        }
        if (!(upgradedata = p_63456_.getUpgradeData()).isEmpty()) {
            compoundtag.put(TAG_UPGRADE_DATA, upgradedata.write());
        }
        LevelChunkSection[] alevelchunksection = p_63456_.getSections();
        ListTag listtag = new ListTag();
        ThreadedLevelLightEngine levellightengine = p_63455_.getChunkSource().getLightEngine();
        Registry registry = p_63455_.registryAccess().registryOrThrow(Registries.BIOME);
        Codec<PalettedContainerRO<Holder<Biome>>> codec = ChunkSerializer.makeBiomeCodec(registry);
        boolean flag = p_63456_.isLightCorrect();
        for (int i = levellightengine.getMinLightSection(); i < levellightengine.getMaxLightSection(); ++i) {
            int j = p_63456_.getSectionIndexFromSectionY(i);
            boolean flag1 = j >= 0 && j < alevelchunksection.length;
            DataLayer datalayer = levellightengine.getLayerListener(LightLayer.BLOCK).getDataLayerData(SectionPos.of((ChunkPos)chunkpos, (int)i));
            DataLayer datalayer1 = levellightengine.getLayerListener(LightLayer.SKY).getDataLayerData(SectionPos.of((ChunkPos)chunkpos, (int)i));
            if (!flag1 && datalayer == null && datalayer1 == null) continue;
            CompoundTag compoundtag1 = new CompoundTag();
            if (flag1) {
                LevelChunkSection levelchunksection = alevelchunksection[j];
                compoundtag1.put("block_states", (Tag)BLOCK_STATE_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, levelchunksection.getStates()).getOrThrow());
                compoundtag1.put("biomes", (Tag)codec.encodeStart((DynamicOps)NbtOps.INSTANCE, levelchunksection.getBiomes()).getOrThrow());
            }
            if (datalayer != null && !datalayer.isEmpty()) {
                compoundtag1.putByteArray(BLOCK_LIGHT_TAG, datalayer.getData());
            }
            if (datalayer1 != null && !datalayer1.isEmpty()) {
                compoundtag1.putByteArray(SKY_LIGHT_TAG, datalayer1.getData());
            }
            if (compoundtag1.isEmpty()) continue;
            compoundtag1.putByte("Y", (byte)i);
            listtag.add((Object)compoundtag1);
        }
        compoundtag.put(SECTIONS_TAG, (Tag)listtag);
        if (flag) {
            compoundtag.putBoolean(IS_LIGHT_ON_TAG, true);
        }
        ListTag listtag1 = new ListTag();
        for (BlockPos blockpos : p_63456_.getBlockEntitiesPos()) {
            CompoundTag compoundtag3 = p_63456_.getBlockEntityNbtForSaving(blockpos, (HolderLookup.Provider)p_63455_.registryAccess());
            if (compoundtag3 == null) continue;
            listtag1.add((Object)compoundtag3);
        }
        compoundtag.put("block_entities", (Tag)listtag1);
        if (p_63456_.getPersistedStatus().getChunkType() == ChunkType.PROTOCHUNK) {
            ProtoChunk protochunk = (ProtoChunk)p_63456_;
            ListTag listtag2 = new ListTag();
            listtag2.addAll((Collection)protochunk.getEntities());
            compoundtag.put("entities", (Tag)listtag2);
            CompoundTag compoundtag4 = new CompoundTag();
            for (GenerationStep.Carving generationstep$carving : GenerationStep.Carving.values()) {
                CarvingMask carvingmask = protochunk.getCarvingMask(generationstep$carving);
                if (carvingmask == null) continue;
                compoundtag4.putLongArray(generationstep$carving.toString(), carvingmask.toArray());
            }
            compoundtag.put("CarvingMasks", compoundtag4);
        } else if (p_63456_ instanceof LevelChunk && (lightTag = (levelChunk = (LevelChunk)p_63456_).getAuxLightManager(chunkpos).serializeNBT((HolderLookup.Provider)p_63455_.registryAccess())) != null) {
            compoundtag.put("neoforge:aux_lights", (Tag)lightTag);
        }
        ChunkSerializer.saveTicks(p_63455_, compoundtag, p_63456_.getTicksForSerialization());
        compoundtag.put("PostProcessing", (Tag)ChunkSerializer.packOffsets(p_63456_.getPostProcessing()));
        CompoundTag compoundtag2 = new CompoundTag();
        for (Map.Entry<Heightmap.Types, Heightmap> entry : p_63456_.getHeightmaps()) {
            if (!p_63456_.getPersistedStatus().heightmapsAfter().contains(entry.getKey())) continue;
            compoundtag2.put(entry.getKey().getSerializationKey(), (Tag)new LongArrayTag(entry.getValue().getRawData()));
        }
        try {
            CompoundTag capTag = p_63456_.writeAttachmentsToNBT((HolderLookup.Provider)p_63455_.registryAccess());
            if (capTag != null) {
                compoundtag.put("neoforge:attachments", capTag);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Failed to write chunk attachments. An attachment has likely thrown an exception trying to write state. It will not persist. Report this to the mod author", (Throwable)exception);
        }
        compoundtag.put(HEIGHTMAPS_TAG, compoundtag2);
        compoundtag.put("structures", ChunkSerializer.packStructureData(StructurePieceSerializationContext.fromLevel((ServerLevel)p_63455_), chunkpos, p_63456_.getAllStarts(), p_63456_.getAllReferences()));
        return compoundtag;
    }

    private static void saveTicks(ServerLevel p_188236_, CompoundTag p_188237_, ChunkAccess.TicksToSave p_188238_) {
        long i = p_188236_.getLevelData().getGameTime();
        p_188237_.put(BLOCK_TICKS_TAG, p_188238_.blocks().save(i, p_258987_ -> BuiltInRegistries.BLOCK.getKey(p_258987_).toString()));
        p_188237_.put(FLUID_TICKS_TAG, p_188238_.fluids().save(i, p_258989_ -> BuiltInRegistries.FLUID.getKey(p_258989_).toString()));
    }

    public static ChunkType getChunkTypeFromTag(@Nullable CompoundTag p_63486_) {
        return p_63486_ != null ? ChunkStatus.byName((String)p_63486_.getString("Status")).getChunkType() : ChunkType.PROTOCHUNK;
    }

    @Nullable
    private static LevelChunk.PostLoadProcessor postLoadChunk(ServerLevel p_196891_, CompoundTag p_196892_) {
        ListTag listtag = ChunkSerializer.getListOfCompoundsOrNull(p_196892_, "entities");
        ListTag listtag1 = ChunkSerializer.getListOfCompoundsOrNull(p_196892_, "block_entities");
        return listtag == null && listtag1 == null ? null : p_196904_ -> {
            if (listtag != null) {
                p_196891_.addLegacyChunkEntities(EntityType.loadEntitiesRecursive((List<? extends Tag>)listtag, p_196891_));
            }
            if (listtag1 != null) {
                for (int i = 0; i < listtag1.size(); ++i) {
                    CompoundTag compoundtag = listtag1.getCompound(i);
                    boolean flag = compoundtag.getBoolean("keepPacked");
                    if (flag) {
                        p_196904_.setBlockEntityNbt(compoundtag);
                        continue;
                    }
                    BlockPos blockpos = BlockEntity.getPosFromTag(compoundtag);
                    BlockEntity blockentity = BlockEntity.loadStatic(blockpos, p_196904_.getBlockState(blockpos), compoundtag, (HolderLookup.Provider)p_196891_.registryAccess());
                    if (blockentity == null) continue;
                    p_196904_.setBlockEntity(blockentity);
                }
            }
        };
    }

    @Nullable
    private static ListTag getListOfCompoundsOrNull(CompoundTag p_196898_, String p_196899_) {
        ListTag listtag = p_196898_.getList(p_196899_, 10);
        return listtag.isEmpty() ? null : listtag;
    }

    private static CompoundTag packStructureData(StructurePieceSerializationContext p_188250_, ChunkPos p_188251_, Map<Structure, StructureStart> p_188252_, Map<Structure, LongSet> p_188253_) {
        CompoundTag compoundtag = new CompoundTag();
        CompoundTag compoundtag1 = new CompoundTag();
        Registry registry = p_188250_.registryAccess().registryOrThrow(Registries.STRUCTURE);
        for (Map.Entry<Structure, StructureStart> entry : p_188252_.entrySet()) {
            ResourceLocation resourcelocation = registry.getKey(entry.getKey());
            compoundtag1.put(resourcelocation.toString(), entry.getValue().createTag(p_188250_, p_188251_));
        }
        compoundtag.put("starts", compoundtag1);
        CompoundTag compoundtag2 = new CompoundTag();
        for (Map.Entry<Structure, LongSet> entry1 : p_188253_.entrySet()) {
            if (entry1.getValue().isEmpty()) continue;
            ResourceLocation resourcelocation1 = registry.getKey(entry1.getKey());
            compoundtag2.put(resourcelocation1.toString(), (Tag)new LongArrayTag(entry1.getValue()));
        }
        compoundtag.put("References", compoundtag2);
        return compoundtag;
    }

    private static Map<Structure, StructureStart> unpackStructureStart(StructurePieceSerializationContext p_188255_, CompoundTag p_188256_, long p_188257_) {
        HashMap map = Maps.newHashMap();
        Registry registry = p_188255_.registryAccess().registryOrThrow(Registries.STRUCTURE);
        CompoundTag compoundtag = p_188256_.getCompound("starts");
        for (String s : compoundtag.getAllKeys()) {
            ResourceLocation resourcelocation = ResourceLocation.tryParse(s);
            Structure structure = (Structure)registry.get(resourcelocation);
            if (structure == null) {
                LOGGER.error("Unknown structure start: {}", (Object)resourcelocation);
                continue;
            }
            StructureStart structurestart = StructureStart.loadStaticStart(p_188255_, compoundtag.getCompound(s), p_188257_);
            if (structurestart == null) continue;
            map.put(structure, structurestart);
        }
        return map;
    }

    private static Map<Structure, LongSet> unpackStructureReferences(RegistryAccess p_208155_, ChunkPos p_208156_, CompoundTag p_208157_) {
        HashMap map = Maps.newHashMap();
        Registry registry = p_208155_.registryOrThrow(Registries.STRUCTURE);
        CompoundTag compoundtag = p_208157_.getCompound("References");
        for (String s : compoundtag.getAllKeys()) {
            ResourceLocation resourcelocation = ResourceLocation.tryParse(s);
            Structure structure = (Structure)registry.get(resourcelocation);
            if (structure == null) {
                LOGGER.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)resourcelocation, (Object)p_208156_);
                continue;
            }
            long[] along = compoundtag.getLongArray(s);
            if (along.length == 0) continue;
            map.put(structure, new LongOpenHashSet(Arrays.stream(along).filter(p_208153_ -> {
                ChunkPos chunkpos = new ChunkPos(p_208153_);
                if (chunkpos.getChessboardDistance(p_208156_) > 8) {
                    LOGGER.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", new Object[]{resourcelocation, chunkpos, p_208156_});
                    return false;
                }
                return true;
            }).toArray()));
        }
        return map;
    }

    public static ListTag packOffsets(ShortList[] p_63491_) {
        ListTag listtag = new ListTag();
        for (ShortList shortlist : p_63491_) {
            ListTag listtag1 = new ListTag();
            if (shortlist != null) {
                for (Short oshort : shortlist) {
                    listtag1.add((Object)ShortTag.valueOf((short)oshort));
                }
            }
            listtag.add((Object)listtag1);
        }
        return listtag;
    }

    public static class ChunkReadException
    extends NbtException {
        public ChunkReadException(String p_331759_) {
            super(p_331759_);
        }
    }
}

