/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HangingStrandBottomBlock
extends GrowingPlantHeadBlock {
    public static final MapCodec<HangingStrandBottomBlock> CODEC = HangingStrandBottomBlock.simpleCodec(HangingStrandBottomBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public HangingStrandBottomBlock(BlockBehaviour.Properties properties) {
        super(properties, Direction.DOWN, SHAPE, false, 0.01);
    }

    public MapCodec<HangingStrandBottomBlock> codec() {
        return CODEC;
    }

    protected Block getBodyBlock() {
        return null;
    }

    public boolean canSurvive(BlockState p_196260_1_, LevelReader p_196260_2_, BlockPos p_196260_3_) {
        BlockPos blockpos = p_196260_3_.relative(this.growthDirection.getOpposite());
        BlockState blockstate = p_196260_2_.getBlockState(blockpos);
        Block block = blockstate.getBlock();
        if (!this.canAttachTo(blockstate)) {
            return false;
        }
        return block == this.getHeadBlock() || block == this.getBodyBlock() || blockstate.is(BlockTags.DRIPSTONE_REPLACEABLE) && blockstate.isFaceSturdy((BlockGetter)p_196260_2_, blockpos, Direction.DOWN);
    }

    public boolean isRandomlyTicking(BlockState p_149653_1_) {
        return false;
    }

    public void randomTick(BlockState p_225542_1_, ServerLevel p_225542_2_, BlockPos p_225542_3_, RandomSource p_225542_4_) {
    }

    protected boolean canGrowInto(BlockState p_230334_1_) {
        return false;
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource p_230332_1_) {
        return 0;
    }

    public boolean isValidBonemealTarget(LevelReader p_176473_1_, BlockPos p_176473_2_, BlockState p_176473_3_) {
        return false;
    }

    public boolean isBonemealSuccess(Level p_180670_1_, RandomSource p_180670_2_, BlockPos p_180670_3_, BlockState p_180670_4_) {
        return false;
    }

    public void performBonemeal(ServerLevel p_225535_1_, RandomSource p_225535_2_, BlockPos p_225535_3_, BlockState p_225535_4_) {
    }
}

