/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block.entity;

import biomesoplenty.api.block.BOPBlockEntities;
import biomesoplenty.block.AnomalyBlock;
import com.google.common.base.Suppliers;
import java.util.LinkedHashSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class AnomalyBlockEntity
extends BlockEntity {
    private long lastTime = -1L;
    private BlockState lastState = null;
    private final Supplier<LinkedHashSet<BlockState>> renderStates = Suppliers.memoize(() -> {
        Registry blockRegistry = this.level.registryAccess().registryOrThrow(Registries.BLOCK);
        return blockRegistry.entrySet().stream().map(e -> ((Block)e.getValue()).defaultBlockState()).filter(state -> state.getRenderShape() == RenderShape.MODEL).collect(Collectors.toCollection(LinkedHashSet::new));
    });

    public AnomalyBlockEntity(BlockPos pos, BlockState state) {
        super(BOPBlockEntities.ANOMALY, pos, state);
    }

    public BlockState getRenderState() {
        BlockState renderState;
        Level level = this.getLevel();
        if (level == null) {
            return Blocks.AIR.defaultBlockState();
        }
        long time = level.getGameTime();
        if (this.lastTime == time && this.lastState != null) {
            return this.lastState;
        }
        RandomSource random = RandomSource.create((long)Mth.getSeed((Vec3i)this.getBlockPos()));
        BlockState state = this.getBlockState();
        LinkedHashSet<BlockState> renderStates = this.renderStates.get();
        int index = random.nextInt(renderStates.size());
        switch ((AnomalyBlock.AnomalyType)((Object)state.getValue(AnomalyBlock.ANOMALY_TYPE))) {
            case VOLATILE: {
                index *= (int)(time / 2L);
                break;
            }
            case QUIRKY: {
                index += (int)(time / 10L);
                break;
            }
            case UNSTABLE: {
                float slowWeight = 0.98f;
                int mode = (Mth.sign((double)(Mth.sin((float)((float)time / 20.0f)) + 0.98f)) + 1) / 2;
                if (mode > 0) {
                    index += (int)(time / 100L);
                    break;
                }
                index += (int)time;
            }
        }
        index = Mth.positiveModulo((int)index, (int)renderStates.size());
        this.lastState = renderState = (BlockState)renderStates.stream().skip(index).findFirst().orElseThrow();
        this.lastTime = time;
        return renderState;
    }
}

