/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.reload;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.Logger;

public abstract class WeightedDynamicRegistry<V extends CodecProvider<? super V> & ILuckyWeighted>
extends DynamicRegistry<V> {
    protected List<WeightedEntry.Wrapper<V>> zeroLuckList = Collections.emptyList();
    protected int zeroLuckTotalWeight = 0;

    public WeightedDynamicRegistry(Logger logger, String path, boolean synced, boolean subtypes) {
        super(logger, path, synced, subtypes);
    }

    @Override
    protected void beginReload() {
        super.beginReload();
        this.zeroLuckList = Collections.emptyList();
        this.zeroLuckTotalWeight = 0;
    }

    @Override
    protected void validateItem(ResourceLocation key, V item) {
        super.validateItem(key, item);
        Preconditions.checkArgument((((ILuckyWeighted)item).getQuality() >= 0.0f ? 1 : 0) != 0, (Object)"Item may not have negative quality!");
        Preconditions.checkArgument((((ILuckyWeighted)item).getWeight() >= 0 ? 1 : 0) != 0, (Object)"Item may not have negative weight!");
    }

    @Override
    protected void onReload() {
        super.onReload();
        this.zeroLuckList = this.registry.values().stream().map(item -> WeightedEntry.wrap((Object)item, (int)((ILuckyWeighted)((Object)item)).getWeight())).toList();
        this.zeroLuckTotalWeight = WeightedRandom.getTotalWeight(this.zeroLuckList);
    }

    @Nullable
    public V getRandomItem(RandomSource rand) {
        return this.getRandomItem(rand, 0.0f);
    }

    @Nullable
    public V getRandomItem(RandomSource rand, float luck) {
        if (luck == 0.0f) {
            return (V)((CodecProvider)WeightedRandom.getRandomItem((RandomSource)rand, this.zeroLuckList, (int)this.zeroLuckTotalWeight).map(WeightedEntry.Wrapper::data).orElse(null));
        }
        return this.getRandomItem(rand, luck, new Predicate[]{Predicates.alwaysTrue()});
    }

    @Nullable
    @SafeVarargs
    public final V getRandomItem(RandomSource rand, float luck, Predicate<V> ... filters) {
        ArrayList list = new ArrayList(this.zeroLuckList.size());
        Stream stream = this.registry.values().stream();
        for (Predicate<V> filter : filters) {
            stream = stream.filter(filter);
        }
        stream.map(l -> ((ILuckyWeighted)((Object)l)).wrap(luck)).forEach(list::add);
        return (V)((CodecProvider)WeightedRandom.getRandomItem((RandomSource)rand, list).map(WeightedEntry.Wrapper::data).orElse(null));
    }

    public static interface ILuckyWeighted {
        public float getQuality();

        public int getWeight();

        default public <T extends ILuckyWeighted> WeightedEntry.Wrapper<T> wrap(float luck) {
            return ILuckyWeighted.wrap(this, luck);
        }

        public static <T extends ILuckyWeighted> WeightedEntry.Wrapper<T> wrap(T item, float luck) {
            return WeightedEntry.wrap(item, (int)Math.max(0, item.getWeight() + (int)(luck * item.getQuality())));
        }
    }

    public static interface IDimensional {
        @Nullable
        public Set<ResourceLocation> getDimensions();

        public static <T extends IDimensional> Predicate<T> createPredicate(ResourceLocation dimId) {
            return obj -> {
                Set<ResourceLocation> dims = obj.getDimensions();
                return dims == null || dims.isEmpty() || dims.contains(dimId);
            };
        }

        public static <T extends IDimensional> Predicate<T> matches(Level level) {
            return IDimensional.createPredicate(level.dimension().location());
        }
    }
}

