/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.event;

import dev.architectury.event.forge.EventHandlerImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public final class EventHandler {
    private static boolean initialized = false;

    private EventHandler() {
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        if (Platform.getEnvironment() == Env.CLIENT) {
            EventHandler.registerClient();
        }
        EventHandler.registerCommon();
        if (Platform.getEnvironment() == Env.SERVER) {
            EventHandler.registerServer();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerClient() {
        EventHandlerImpl.registerClient();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerCommon() {
        EventHandlerImpl.registerCommon();
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerServer() {
        EventHandlerImpl.registerServer();
    }
}

