/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.configured.client.screen.ILabelProvider;
import com.mrcrayfish.configured.client.screen.TooltipScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public abstract class ListMenuScreen
extends TooltipScreen {
    public static final ResourceLocation CONFIGURED_LOGO = ResourceLocation.fromNamespaceAndPath((String)"configured", (String)"textures/gui/logo.png");
    protected final Screen parent;
    protected final int itemHeight;
    protected EntryList list;
    protected List<Item> entries;
    protected FocusedEditBox activeTextField;
    protected FocusedEditBox searchTextField;

    protected ListMenuScreen(Screen parent, Component title, int itemHeight) {
        super(title);
        this.parent = parent;
        this.itemHeight = itemHeight;
    }

    protected abstract void constructEntries(List<Item> var1);

    protected void init() {
        ArrayList<Item> entries = new ArrayList<Item>();
        this.constructEntries(entries);
        this.entries = ImmutableList.copyOf(entries);
        this.list = new EntryList(this, this.entries);
        this.addWidget((GuiEventListener)this.list);
        this.searchTextField = new FocusedEditBox(this.font, this.width / 2 - 110, 22, 220, 20, (Component)Component.translatable((String)"configured.gui.search"));
        this.searchTextField.setClearable(true);
        this.searchTextField.setResponder(s -> this.updateSearchResults());
        this.addWidget((GuiEventListener)this.searchTextField);
        ScreenUtil.updateSearchTextFieldSuggestion(this.searchTextField, "", this.entries);
    }

    protected void updateSearchResults() {
        String query = this.searchTextField.getValue();
        ScreenUtil.updateSearchTextFieldSuggestion(this.searchTextField, query, this.entries);
        this.list.replaceEntries(query.isEmpty() ? this.entries : this.getSearchResults(query));
        if (!query.isEmpty()) {
            this.list.setScrollAmount(0.0);
        }
    }

    protected Collection<Item> getSearchResults(String s) {
        return this.entries.stream().filter(item -> !(item instanceof IIgnoreSearch) && item.getLabel().toLowerCase(Locale.ENGLISH).contains(s.toLowerCase(Locale.ENGLISH))).collect(Collectors.toList());
    }

    protected void updateTooltip(int mouseX, int mouseY) {
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, mouseX, mouseY)) {
            this.setActiveTooltip((Component)Component.translatable((String)"configured.gui.info"));
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.resetTooltip();
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.list.render(graphics, mouseX, mouseY, partialTicks);
        this.searchTextField.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 7, 0xFFFFFF);
        this.renderForeground(graphics, mouseX, mouseY, partialTicks);
        graphics.blit(CONFIGURED_LOGO, 10, 13, 0, 0.0f, 0.0f, 23, 23, 32, 32);
        graphics.blit(IconButton.ICONS, this.width / 2 - 128, 26, 14, 14, 22.0f, 11.0f, 10, 10, 64, 64);
        this.updateTooltip(mouseX, mouseY);
        if (this.tooltipText != null) {
            this.drawTooltip(graphics, mouseX, mouseY);
        } else {
            GuiEventListener widget;
            Iterator iterator = this.children().iterator();
            while (!(!iterator.hasNext() || (widget = (GuiEventListener)iterator.next()) instanceof Button && ((Button)widget).isHoveredOrFocused())) {
            }
        }
    }

    protected void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, (int)mouseX, (int)mouseY)) {
            Style style = Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/configured"));
            this.handleComponentClicked(style);
            return true;
        }
        if (this.activeTextField != null && !this.activeTextField.isMouseOver(mouseX, mouseY)) {
            this.activeTextField.setFocused(false);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected class EntryList
    extends ContainerObjectSelectionList<Item> {
        public EntryList(ListMenuScreen this$0, List<Item> entries) {
            super(this$0.minecraft, this$0.width, this$0.height - 36 - 50, 50, this$0.itemHeight);
            entries.forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
        }

        protected int getScrollbarPosition() {
            return this.width / 2 + 144;
        }

        public int getRowWidth() {
            return 260;
        }

        public void replaceEntries(Collection<Item> entries) {
            super.replaceEntries(entries);
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.renderWidget(graphics, mouseX, mouseY, partialTicks);
            this.renderToolTips(graphics, mouseX, mouseY);
        }

        private void renderToolTips(GuiGraphics graphics, int mouseX, int mouseY) {
            this.children().forEach(item -> item.children().forEach(o -> {
                if (o instanceof Button) {
                    // empty if block
                }
            }));
        }
    }

    protected class FocusedEditBox
    extends EditBox {
        private boolean clearable;

        public FocusedEditBox(Font font, int x, int y, int width, int height, Component label) {
            super(font, x, y, width, height, label);
            this.clearable = false;
        }

        public FocusedEditBox setClearable(boolean clearable) {
            this.clearable = clearable;
            return this;
        }

        public void setFocused(boolean focused) {
            super.setFocused(focused);
            if (focused) {
                if (ListMenuScreen.this.activeTextField != null && ListMenuScreen.this.activeTextField != this) {
                    ListMenuScreen.this.activeTextField.setFocused(false);
                }
                ListMenuScreen.this.activeTextField = this;
            }
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            super.renderWidget(graphics, mouseX, mouseY, partialTick);
            if (this.clearable && !this.getValue().isEmpty()) {
                RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
                boolean hovered = ScreenUtil.isMouseWithin(this.getX() + this.width - 15, this.getY() + 5, 9, 9, mouseX, mouseY);
                graphics.blit(IconButton.ICONS, this.getX() + this.width - 15, this.getY() + 5, 9, 9, hovered ? 9.0f : 0.0f, 55.0f, 9, 9, 64, 64);
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.clearable && !this.getValue().isEmpty() && button == 0 && ScreenUtil.isMouseWithin(this.getX() + this.width - 15, this.getY() + 5, 9, 9, (int)mouseX, (int)mouseY)) {
                this.playDownSound(ListMenuScreen.this.minecraft.getSoundManager());
                this.setValue("");
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
    }

    protected static interface IIgnoreSearch {
    }

    protected abstract class Item
    extends ContainerObjectSelectionList.Entry<Item>
    implements ILabelProvider,
    Comparable<Item> {
        protected final Component label;
        @Nullable
        protected List<FormattedCharSequence> tooltip;

        public Item(Component label) {
            this.label = label;
        }

        public Item(String label) {
            this.label = Component.literal((String)label);
        }

        @Override
        public String getLabel() {
            return this.label.getString();
        }

        public void render(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            if (this.isMouseOver(mouseX, mouseY)) {
                ListMenuScreen.this.setActiveTooltip(this.tooltip);
            }
        }

        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority narrationPriority() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void updateNarration(NarrationElementOutput output) {
                    output.add(NarratedElementType.TITLE, Item.this.label);
                }
            });
        }

        @Override
        public int compareTo(Item o) {
            return this.label.getString().compareTo(o.label.getString());
        }
    }

    public class MultiTextItem
    extends Item
    implements IIgnoreSearch {
        private final Component bottomText;

        public MultiTextItem(Component topText, Component bottomText) {
            super(topText);
            this.bottomText = bottomText;
        }

        @Override
        public void render(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            Style style;
            HoverEvent event;
            graphics.drawCenteredString(((ListMenuScreen)ListMenuScreen.this).minecraft.font, this.label, left + width / 2, top, -1);
            graphics.drawCenteredString(((ListMenuScreen)ListMenuScreen.this).minecraft.font, this.bottomText, left + width / 2, top + 12, -1);
            if (this.isMouseOver(mouseX, mouseY) && (event = (style = this.bottomText.getStyle()).getHoverEvent()) != null && event.getAction() == HoverEvent.Action.SHOW_TEXT) {
                ListMenuScreen.this.setActiveTooltip((Component)event.getValue(HoverEvent.Action.SHOW_TEXT), -219136);
            }
        }
    }

    public class TitleItem
    extends Item
    implements IIgnoreSearch {
        public TitleItem(Component title) {
            super(title);
        }

        public TitleItem(String title) {
            super((Component)Component.literal((String)title).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.YELLOW));
        }

        @Override
        public void render(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            graphics.drawCenteredString(((ListMenuScreen)ListMenuScreen.this).minecraft.font, this.label, left + width / 2, top + 5, 0xFFFFFF);
        }
    }
}

