/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl.neoforge;

import com.mrcrayfish.configured.api.IConfigValue;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class NeoForgeValue<T>
implements IConfigValue<T> {
    public final ModConfigSpec.ConfigValue<T> configValue;
    public final ModConfigSpec.ValueSpec valueSpec;
    protected final T initialValue;
    protected T value;
    protected Pair<T, T> range;
    protected Component validationHint;

    public NeoForgeValue(ModConfigSpec.ConfigValue<T> configValue, ModConfigSpec.ValueSpec valueSpec) {
        this.configValue = configValue;
        this.valueSpec = valueSpec;
        this.initialValue = configValue.get();
        this.set(configValue.get());
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public void set(T value) {
        this.value = value;
    }

    @Override
    public boolean isDefault() {
        return Objects.equals(this.get(), this.valueSpec.getDefault());
    }

    @Override
    public boolean isChanged() {
        return !Objects.equals(this.get(), this.initialValue);
    }

    @Override
    public void restore() {
        this.set(this.getDefault());
    }

    @Override
    public T getDefault() {
        return (T)this.valueSpec.getDefault();
    }

    @Override
    public boolean isValid(T value) {
        return this.valueSpec.test(value);
    }

    @Override
    @Nullable
    public Component getComment() {
        String rawComment = this.valueSpec.getComment();
        String key = this.getTranslationKey() + ".tooltip";
        if (I18n.exists((String)key)) {
            MutableComponent comment = Component.translatable((String)key);
            if (rawComment != null) {
                int rangeIndex = rawComment.indexOf("Range: ");
                int allowedValIndex = rawComment.indexOf("Allowed Values: ");
                if (rangeIndex >= 0 || allowedValIndex >= 0) {
                    comment.append((Component)Component.literal((String)rawComment.substring(Math.max(rangeIndex, allowedValIndex) - 1)));
                }
            }
            return comment;
        }
        return rawComment != null ? Component.literal((String)rawComment) : null;
    }

    @Override
    public String getTranslationKey() {
        return this.valueSpec.getTranslationKey();
    }

    @Override
    @Nullable
    public Component getValidationHint() {
        if (this.validationHint == null) {
            this.loadRange();
            if (this.range != null && this.range.getLeft() != null && this.range.getRight() != null) {
                this.validationHint = Component.translatable((String)"configured.validator.range_hint", (Object[])new Object[]{this.range.getLeft().toString(), this.range.getRight().toString()});
            }
        }
        return this.validationHint;
    }

    @Override
    public String getName() {
        return NeoForgeValue.lastValue(this.configValue.getPath(), "");
    }

    @Override
    public void cleanCache() {
        this.configValue.clearCache();
    }

    @Override
    public boolean requiresWorldRestart() {
        return this.valueSpec.restartType() == ModConfigSpec.RestartType.WORLD;
    }

    @Override
    public boolean requiresGameRestart() {
        return this.valueSpec.restartType() == ModConfigSpec.RestartType.GAME;
    }

    public static <V> V lastValue(List<V> list, V defaultValue) {
        if (!list.isEmpty()) {
            return list.get(list.size() - 1);
        }
        return defaultValue;
    }

    public void loadRange() {
        if (this.range == null) {
            this.range = Pair.of((Object)this.valueSpec.getRange().getMin(), (Object)this.valueSpec.getRange().getMax());
        }
    }
}

