/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.coroutil.util;

import com.corosus.coroutil.util.CULog;
import java.lang.reflect.Method;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class CoroUtilCompatibility {
    private static boolean sereneSeasonsInstalled = false;
    private static boolean checksereneSeasons = true;
    private static Class class_SereneSeasons_ASMHelper = null;
    private static Method method_sereneSeasons_getFloatTemperature = null;

    public static boolean tryPathToXYZModCompat(Mob ent, int x, int y, int z, double speed) {
        return CoroUtilCompatibility.tryPathToXYZVanilla(ent, x, y, z, speed);
    }

    public static boolean tryPathToXYZVanilla(Mob ent, int x, int y, int z, double speed) {
        return ent.getNavigation().moveTo((double)x, (double)y, (double)z, speed);
    }

    public static float getAdjustedTemperature(Level world, Biome biome, BlockPos pos) {
        if (CoroUtilCompatibility.isSereneSeasonsInstalled()) {
            try {
                if (method_sereneSeasons_getFloatTemperature == null) {
                    method_sereneSeasons_getFloatTemperature = class_SereneSeasons_ASMHelper.getDeclaredMethod("getBiomeTemperature", Level.class, Holder.class, BlockPos.class);
                }
                Holder biomeHolder = world.getBiome(pos);
                return ((Float)method_sereneSeasons_getFloatTemperature.invoke(null, world, biomeHolder, pos)).floatValue();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                sereneSeasonsInstalled = false;
                return biome.getTemperature(pos);
            }
        }
        return biome.getTemperature(pos);
    }

    public static boolean isSereneSeasonsInstalled() {
        if (checksereneSeasons) {
            try {
                checksereneSeasons = false;
                class_SereneSeasons_ASMHelper = Class.forName("sereneseasons.season.SeasonHooks");
                if (class_SereneSeasons_ASMHelper != null) {
                    sereneSeasonsInstalled = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            CULog.log("CoroUtil detected Serene Seasons " + (sereneSeasonsInstalled ? "Installed" : "Not Installed") + " for use");
        }
        return sereneSeasonsInstalled;
    }

    public static boolean coldEnoughToSnow(Biome biome, BlockPos pos, Level levelReader) {
        return !CoroUtilCompatibility.warmEnoughToRain(biome, pos, levelReader);
    }

    public static boolean warmEnoughToRain(Biome biome, BlockPos pos, Level levelReader) {
        return CoroUtilCompatibility.getAdjustedTemperature(levelReader, biome, pos) >= 0.15f;
    }
}

