/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.config.manager.ConfigManagerClient;
import dev.ftb.mods.ftblibrary.config.ui.ChooseConfigScreen;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record EditConfigChoicePacket(ConfigType configType, String clientConfig, String serverConfig, Component title) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EditConfigChoicePacket> TYPE = new CustomPacketPayload.Type(FTBLibrary.rl("edit_config_choice_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, EditConfigChoicePacket> STREAM_CODEC = StreamCodec.composite(NetworkHelper.enumStreamCodec(ConfigType.class), EditConfigChoicePacket::configType, (StreamCodec)ByteBufCodecs.STRING_UTF8, EditConfigChoicePacket::clientConfig, (StreamCodec)ByteBufCodecs.STRING_UTF8, EditConfigChoicePacket::serverConfig, (StreamCodec)ComponentSerialization.STREAM_CODEC, EditConfigChoicePacket::title, EditConfigChoicePacket::new);

    public CustomPacketPayload.Type<EditConfigChoicePacket> type() {
        return TYPE;
    }

    public static EditConfigChoicePacket choose(String clientConfig, String serverConfig, Component title) {
        return new EditConfigChoicePacket(ConfigType.CHOOSE, clientConfig, serverConfig, title);
    }

    public static EditConfigChoicePacket client(String clientConfig) {
        return new EditConfigChoicePacket(ConfigType.CLIENT, clientConfig, "", (Component)Component.empty());
    }

    public static EditConfigChoicePacket server(String serverConfig) {
        return new EditConfigChoicePacket(ConfigType.SERVER, "", serverConfig, (Component)Component.empty());
    }

    public static void handle(EditConfigChoicePacket message, NetworkManager.PacketContext context) {
        switch (message.configType.ordinal()) {
            case 0: {
                ConfigManagerClient.editConfig(message.clientConfig);
                break;
            }
            case 1: {
                if (!context.getPlayer().hasPermissions(2)) break;
                ConfigManagerClient.editConfig(message.serverConfig());
                break;
            }
            case 2: {
                if (context.getPlayer().hasPermissions(2)) {
                    ChooseConfigScreen.open(message);
                    break;
                }
                ConfigManagerClient.editConfig(message.clientConfig());
            }
        }
    }

    public static enum ConfigType {
        CLIENT,
        SERVER,
        CHOOSE;

    }
}

