/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.rightclick;

import dev.ftb.mods.ftbultimine.FTBUltimine;
import dev.ftb.mods.ftbultimine.api.FTBUltimineAPI;
import dev.ftb.mods.ftbultimine.api.rightclick.RightClickHandler;
import dev.ftb.mods.ftbultimine.api.shape.ShapeContext;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public enum FarmlandConversion implements RightClickHandler
{
    INSTANCE;


    @Override
    public int handleRightClickBlock(ShapeContext shapeContext, InteractionHand hand, Collection<BlockPos> positions) {
        ServerPlayer player = shapeContext.player();
        if (!((Boolean)FTBUltimineServerConfig.RIGHT_CLICK_HOE.get()).booleanValue() || !(player.getItemInHand(hand).getItem() instanceof HoeItem)) {
            return 0;
        }
        int clicked = 0;
        for (BlockPos pos : positions) {
            BlockState state;
            if (!player.level().getBlockState(pos.above()).isAir() || !(state = player.level().getBlockState(pos)).is(FTBUltimine.TILLABLE_TAG)) continue;
            player.level().setBlock(pos, Blocks.FARMLAND.defaultBlockState(), 11);
            player.level().gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)Blocks.FARMLAND.defaultBlockState()));
            ++clicked;
            player.causeFoodExhaustion((float)(FTBUltimineServerConfig.getExhaustionPerBlock(player) * 0.005));
            if (!this.hurtItemAndCheckIfBroken(player, hand) && !FTBUltimineAPI.isTooExhausted(player)) continue;
            break;
        }
        if (clicked > 0) {
            player.level().playSound((Player)player, shapeContext.pos(), SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return clicked;
    }
}

