/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.geom.Point2D;
import journeymap.client.JourneymapClient;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.Renderer;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.client.waypoint.ClientWaypointImpl;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;

public class DrawWayPointStep
implements DrawStep {
    public final ClientWaypointImpl waypoint;
    final DynamicTexture texture;
    final boolean isEdit;
    Point2D.Double lastPosition;
    boolean lastOnScreen;
    boolean showLabel;
    double labelScale = 0.0;
    float iconScale = 0.0f;

    public DrawWayPointStep(ClientWaypointImpl waypoint) {
        this(waypoint, false);
    }

    public DrawWayPointStep(ClientWaypointImpl waypoint, boolean isEdit) {
        this.waypoint = waypoint;
        this.isEdit = isEdit;
        this.texture = waypoint.getTexture();
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public void setLabelScale(float labelScale) {
        this.labelScale = labelScale;
    }

    public void setIconScale(float iconScale) {
        this.iconScale = iconScale;
    }

    @Override
    public void draw(GuiGraphics graphics, MultiBufferSource buffers, DrawStep.Pass pass, double xOffset, double yOffset, Renderer renderer, double fontScale, double rotation) {
        if (!(this.waypoint.isInPlayerDimension() && JourneymapClient.getInstance().getStateHandler().isWaypointsAllowed() && JourneymapClient.getInstance().getWaypointProperties().renderWaypoints.get().booleanValue() && JourneymapClient.getInstance().getWaypointProperties().renderWaypointsMap.get().booleanValue())) {
            return;
        }
        Point2D.Double pixel = this.getPosition(xOffset, yOffset, renderer, true);
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 800.0f);
        if (renderer.isOnScreen(pixel)) {
            if (this.showLabel && (pass == DrawStep.Pass.TextBG || pass == DrawStep.Pass.Text)) {
                int fontColor;
                int labelOffset = rotation == 0.0 ? -((TextureAccess)this.texture).journeymap$getHeight() / 2 : ((TextureAccess)this.texture).journeymap$getHeight() / 2;
                labelOffset = this.iconScale <= 1.0f ? labelOffset : (int)((float)labelOffset * this.iconScale);
                this.labelScale = this.labelScale == 0.0 ? fontScale : this.labelScale;
                Point2D labelPoint = renderer.shiftWindowPosition(pixel.getX(), pixel.getY(), 0, labelOffset);
                String waypointName = this.waypoint.getDisplayName();
                int n = this.waypoint.isDeathPoint() ? 0xFF0000 : (fontColor = this.isEdit ? 0xFFFFFF : this.waypoint.getSafeColor());
                if (this.waypoint.isDeathPoint() && !JourneymapClient.getInstance().getWaypointProperties().showDeathpointlabel.get().booleanValue()) {
                    waypointName = "";
                }
                DrawUtil.drawBatchLabel(graphics.pose(), (Component)Component.literal((String)waypointName), pass, buffers, labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, 0, 0.7f, fontColor, 1.0f, this.labelScale, false, rotation);
            } else if (this.isEdit && pass == DrawStep.Pass.PreObject) {
                DynamicTexture editTex = TextureCache.getTexture(TextureCache.WaypointEdit);
                RenderType renderType = JMRenderTypes.getIcon((AbstractTexture)editTex);
                VertexConsumer vertexBuilder = buffers.getBuffer(renderType);
                DrawUtil.drawWaypointIcon(graphics.pose(), vertexBuilder, editTex, this.iconScale, this.waypoint.getIconColor(), 1.0f, pixel.getX(), pixel.getY(), rotation);
            }
            if (pass == DrawStep.Pass.Object) {
                RenderType renderType = JMRenderTypes.getIconNoBlur((AbstractTexture)this.texture);
                VertexConsumer vertexBuilder = buffers.getBuffer(renderType);
                DrawUtil.drawWaypointIcon(graphics.pose(), vertexBuilder, this.texture, this.iconScale, this.waypoint.getIconColor(), 1.0f, pixel.getX(), pixel.getY(), rotation);
            }
        } else if (!this.isEdit && pass == DrawStep.Pass.Object) {
            renderer.ensureOnScreen(pixel);
            RenderType renderType = JMRenderTypes.getIconNoBlur((AbstractTexture)this.texture);
            VertexConsumer vertexBuilder = buffers.getBuffer(renderType);
            DrawUtil.drawWaypointIcon(graphics.pose(), vertexBuilder, this.texture, this.iconScale, this.waypoint.getIconColor(), 1.0f, pixel.getX(), pixel.getY(), rotation);
        }
        graphics.pose().popPose();
    }

    public void drawOffscreen(GuiGraphics graphics, MultiBufferSource buffers, DrawStep.Pass pass, Point2D pixel, double rotation) {
        if (pass == DrawStep.Pass.Object) {
            RenderType renderType = JMRenderTypes.getIconUnmasked((AbstractTexture)this.texture);
            VertexConsumer vertexBuilder = buffers.getBuffer(renderType);
            DrawUtil.drawWaypointIcon(graphics.pose(), vertexBuilder, this.texture, this.iconScale, this.waypoint.getIconColor(), 1.0f, pixel.getX() - (double)(((TextureAccess)this.texture).journeymap$getWidth() >> 1), pixel.getY() - (double)(((TextureAccess)this.texture).journeymap$getHeight() >> 1), rotation);
        }
    }

    public Point2D.Double getPosition(double xOffset, double yOffset, Renderer renderer, boolean forceUpdate) {
        if (!forceUpdate && this.lastPosition != null) {
            return this.lastPosition;
        }
        double x = (double)this.waypoint.getX() + 0.5;
        double z = (double)this.waypoint.getZ() + 0.5;
        Point2D.Double pixel = renderer.getBlockPixelInGrid(x, z);
        pixel.setLocation(pixel.getX() + xOffset, pixel.getY() + yOffset);
        this.lastPosition = pixel;
        return pixel;
    }

    public boolean isOnScreen() {
        return this.lastOnScreen;
    }

    public void setOnScreen(boolean lastOnScreen) {
        this.lastOnScreen = lastOnScreen;
    }

    @Override
    public int getDisplayOrder() {
        return 0;
    }

    @Override
    public String getModId() {
        return this.waypoint.getOrigin();
    }

    public static class SimpleCacheLoader
    extends CacheLoader<ClientWaypointImpl, DrawWayPointStep> {
        public DrawWayPointStep load(ClientWaypointImpl holder) throws Exception {
            return new DrawWayPointStep(holder);
        }
    }
}

