/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog.about;

import com.mojang.authlib.GameProfile;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import journeymap.client.Constants;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;

public class SplashHead
extends AbstractWidget {
    public final String name;
    public final String uuid;
    public final String title;
    public int width;
    public double moveX;
    public double moveY;
    private double moveDistance = 1.0;
    private Random r = new Random();
    protected Rectangle2D.Double bounds;

    public SplashHead(String uuid, String name, String titleKey) {
        super(20, 20, 20, 20, (Component)Component.empty());
        this.uuid = uuid;
        this.name = name;
        this.title = titleKey != null ? Constants.getString(titleKey) : "";
    }

    public DynamicTexture getSkin() {
        return TextureCache.getPlayerSkin(new GameProfile(UUID.fromString(this.uuid), this.name));
    }

    public int getWidth(Font fr) {
        String[] nameParts;
        this.width = fr.width(this.title);
        for (String part : nameParts = this.name.trim().split(" ")) {
            this.width = Math.max(this.width, fr.width(part));
        }
        return this.width;
    }

    public void renderWidget(GuiGraphics guiGraphics, int i, int i1, float v) {
        int imgY = this.getY() - 2;
        int imgX = this.getCenterX() - 10;
        Objects.requireNonNull(Minecraft.getInstance().font);
        int lineHeight = (int)(9.0 * 1.4);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, -1.0f);
        DrawUtil.drawGradientRect(guiGraphics, imgX - 1, imgY - 1, 22.0, 22.0, 0, 0.4f, 0, 0.8f);
        DrawUtil.drawQuad(guiGraphics.pose(), this.getSkin(), 0xFFFFFF, 1.0f, (double)imgX, (double)imgY, 20.0, 20.0, false, 0.0);
        int y = imgY + 24;
        String name = this.name.trim();
        String name2 = null;
        boolean twoLineName = name.contains(" ");
        if (twoLineName) {
            String[] parts = this.name.split(" ");
            name = parts[0];
            name2 = parts[1];
        }
        DrawUtil.drawLabel(guiGraphics, name, this.getCenterX(), y, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.0f, 0xFFFFFF, 1.0f, 1.0, true);
        y += lineHeight;
        if (name2 != null) {
            DrawUtil.drawLabel(guiGraphics, name2, this.getCenterX(), y, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.0f, 0xFFFFFF, 1.0f, 1.0, true);
            y += lineHeight;
        }
        DrawUtil.drawLabel(guiGraphics, this.title, this.getCenterX(), y, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.0f, 65280, 1.0f, 1.0, true);
        guiGraphics.pose().popPose();
    }

    public void setWidth(int minWidth) {
        this.width = minWidth;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void randomizeVector() {
        this.moveDistance = this.r.nextDouble() + 0.5;
        this.moveX = this.r.nextBoolean() ? this.moveDistance : -this.moveDistance;
        this.moveDistance = this.r.nextDouble() + 0.5;
        this.moveY = this.r.nextBoolean() ? this.moveDistance : -this.moveDistance;
    }

    public void adjustVector(Rectangle2D.Double screenBounds) {
        Rectangle2D.Double buttonBounds = new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        if (!screenBounds.contains(buttonBounds)) {
            int xMargin = this.getWidth();
            int yMargin = this.getHeight();
            if (buttonBounds.getMinX() <= (double)xMargin) {
                this.moveX = this.moveDistance;
            } else if (buttonBounds.getMaxX() >= screenBounds.getWidth() - (double)xMargin) {
                this.moveX = -this.moveDistance;
            }
            if (buttonBounds.getMinY() <= (double)yMargin) {
                this.moveY = this.moveDistance;
            } else if (buttonBounds.getMaxY() >= screenBounds.getHeight() - (double)yMargin) {
                this.moveY = -this.moveDistance;
            }
        }
        this.continueVector();
    }

    public void continueVector() {
        int x = (int)Math.round((double)this.getX() + this.moveX);
        int y = (int)Math.round((double)this.getY() + this.moveY);
        this.setX(x);
        this.setY(y);
    }

    public void avoid(List<SplashHead> others) {
        for (SplashHead other : others) {
            if (this == other || !(this.getDistance(other) <= (double)this.getWidth())) continue;
            this.randomizeVector();
            break;
        }
    }

    public int getCenterX() {
        return super.getX() + this.width / 2;
    }

    protected Rectangle2D.Double updateBounds() {
        this.bounds = new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return this.bounds;
    }

    public Rectangle2D.Double getBounds() {
        if (this.bounds == null) {
            return this.updateBounds();
        }
        return this.bounds;
    }

    public int getMiddleY() {
        return super.getY() + this.height / 2;
    }

    public double getDistance(SplashHead other) {
        double px = this.getCenterX() - other.getCenterX();
        double py = this.getMiddleY() - other.getMiddleY();
        return Math.sqrt(px * px + py * py);
    }
}

