/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.option;

import com.google.common.base.Strings;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.SliderButton;
import journeymap.client.ui.component.buttons.TextFieldButton;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;

public class ButtonListSlot
extends Slot
implements Comparable<ButtonListSlot> {
    static int hgap = 8;
    Minecraft mc = Minecraft.getInstance();
    Font fontRenderer;
    ButtonList buttons;
    Map<Button, SlotMetadata> buttonOptionMetadata;
    CategorySlot parent;
    SlotMetadata lastPressed;
    SlotMetadata currentToolTip;
    Integer colorToolbarBgStart;
    Integer colorToolbarBgEnd;

    public ButtonListSlot(CategorySlot parent) {
        this.fontRenderer = Minecraft.getInstance().font;
        this.buttons = new ButtonList();
        this.buttonOptionMetadata = new HashMap<Button, SlotMetadata>();
        this.lastPressed = null;
        this.currentToolTip = null;
        this.colorToolbarBgStart = new Color(0, 0, 100).getRGB();
        this.colorToolbarBgEnd = new Color(0, 0, 100).getRGB();
        this.parent = parent;
    }

    public ButtonListSlot add(SlotMetadata slotMetadata) {
        this.buttons.add(slotMetadata.getButton());
        this.buttonOptionMetadata.put(slotMetadata.getButton(), slotMetadata);
        return this;
    }

    public ButtonListSlot addAll(Collection<SlotMetadata> slotMetadataCollection) {
        for (SlotMetadata slotMetadata : slotMetadataCollection) {
            this.add(slotMetadata);
        }
        return this;
    }

    public ButtonListSlot merge(ButtonListSlot other) {
        for (SlotMetadata otherSlot : other.buttonOptionMetadata.values()) {
            this.add(otherSlot);
        }
        return this;
    }

    public void clear() {
        this.buttons.clear();
        this.buttonOptionMetadata.clear();
    }

    @Override
    public Collection<SlotMetadata> getMetadata() {
        return this.buttonOptionMetadata.values();
    }

    public void render(GuiGraphics graphics, int slotIndex, int y, int x, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
        int margin = 0;
        if (this.parent.getCurrentColumnWidth() > 0) {
            int cols = this.parent.currentColumns;
            margin = (listWidth - (hgap * cols - 1 + cols * this.parent.getCurrentColumnWidth())) / 2;
            x += margin;
            listWidth -= margin * 2;
        }
        SlotMetadata tooltipMetadata = null;
        if (this.buttons.size() > 0) {
            this.buttons.setHeights(slotHeight);
            if (this.buttonOptionMetadata.get(this.buttons.get(0)).isToolbar()) {
                this.buttons.fitWidths(this.fontRenderer);
                this.buttons.layoutHorizontal(x + listWidth - hgap, y, false, hgap);
                if (this.buttons.getLeftX() < x) {
                    x = this.buttons.getLeftX() - hgap;
                    listWidth = this.buttons.getRightX() + hgap;
                }
                DrawUtil.drawGradientRect(graphics, x, y, listWidth, slotHeight, this.colorToolbarBgStart, 0.15f, this.colorToolbarBgEnd, 0.6f);
            } else {
                this.buttons.setWidths(this.parent.currentColumnWidth);
                this.buttons.layoutHorizontal(x, y, true, hgap);
            }
            for (Button button : this.buttons) {
                button.render(graphics, mouseX, mouseY, 0.0f);
                if (tooltipMetadata != null || !button.mouseOver(mouseX, mouseY)) continue;
                tooltipMetadata = this.buttonOptionMetadata.get((Object)button);
            }
        } else {
            Journeymap.getLogger().warn("no buttons in " + this.parent.category.getLabel());
        }
        this.currentToolTip = tooltipMetadata;
    }

    public boolean mouseClicked(double x, double y, int mouseButton) {
        if (mouseButton == 0) {
            for (Button button : this.buttons) {
                if (!button.mouseClicked(x, y, mouseButton)) continue;
                this.lastPressed = this.buttonOptionMetadata.get((Object)button);
                return true;
            }
        }
        return false;
    }

    public boolean mouseReleased(double x, double y, int mouseButton) {
        for (Button button : this.buttons) {
            button.mouseReleased(x, y, mouseButton);
        }
        return true;
    }

    public boolean charTyped(char typedChar, int keyCode) {
        for (SlotMetadata slot : this.buttonOptionMetadata.values()) {
            Button button = slot.button;
            if (!slot.equals(this.lastPressed) || !button.isMouseOver() || !(button instanceof TextFieldButton)) continue;
            return button.charTyped(typedChar, keyCode);
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double mouseDX, double mouseDY) {
        for (SlotMetadata slot : this.buttonOptionMetadata.values()) {
            Button button = slot.button;
            if (!slot.equals(this.lastPressed) || !button.isMouseOver() || !(button instanceof SliderButton) && !(button instanceof TextFieldButton)) continue;
            return button.mouseDragged(mouseX, mouseY, mouseButton, mouseDX, mouseDY);
        }
        return false;
    }

    public boolean keyPressed(int key, int value, int modifier) {
        for (SlotMetadata slot : this.buttonOptionMetadata.values()) {
            Button button = slot.button;
            if (!slot.equals(this.lastPressed) || !button.isMouseOver() || !(button instanceof TextFieldButton) && !(button instanceof SliderButton)) continue;
            return button.keyPressed(key, value, modifier);
        }
        return false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (SlotMetadata slot : this.buttonOptionMetadata.values()) {
            if (slot.isMasterPropertyForCategory()) continue;
            slot.button.setEnabled(enabled);
        }
    }

    public List<Slot> getChildSlots(int listWidth, int columnWidth) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public SlotMetadata getLastPressed() {
        return this.lastPressed;
    }

    @Override
    public SlotMetadata getCurrentTooltip() {
        return this.currentToolTip;
    }

    @Override
    public int getColumnWidth() {
        this.buttons.equalizeWidths(this.fontRenderer);
        return ((Button)((Object)this.buttons.get(0))).getWidth();
    }

    @Override
    public boolean contains(SlotMetadata slotMetadata) {
        return this.buttonOptionMetadata.values().contains(slotMetadata);
    }

    protected String getFirstButtonString() {
        if (this.buttons.size() > 0) {
            return ((Button)((Object)this.buttons.get(0))).getMessage().getString();
        }
        return null;
    }

    @Override
    public int compareTo(ButtonListSlot o) {
        String buttonString = this.getFirstButtonString();
        String otherButtonString = o.getFirstButtonString();
        if (!Strings.isNullOrEmpty((String)buttonString)) {
            return buttonString.compareTo(otherButtonString);
        }
        if (!Strings.isNullOrEmpty((String)otherButtonString)) {
            return 1;
        }
        return 0;
    }
}

