/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.option;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.properties.ClientCategory;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.dialog.FullscreenActions;
import journeymap.client.ui.option.ButtonListSlot;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.common.properties.catagory.Category;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;

public class CategorySlot
extends Slot
implements Comparable<CategorySlot> {
    final DynamicTexture curseforgeTexutre = TextureCache.getTexture(TextureCache.CurseForge);
    final DynamicTexture modrinthTexture = TextureCache.getTexture(TextureCache.Modrinth);
    Minecraft mc = Minecraft.getInstance();
    SlotMetadata metadata;
    Category category;
    int currentSlotIndex;
    Button button;
    int currentListWidth;
    int currentColumns;
    int currentColumnWidth;
    SlotMetadata masterSlot;
    SlotMetadata currentTooltip;
    List<SlotMetadata> childMetadataList = new LinkedList<SlotMetadata>();
    List<Slot> childSlots = new ArrayList<Slot>();
    protected DynamicTexture glyphIcon = TextureCache.getTexture(TextureCache.ARROW_GLYPH);
    protected DynamicTexture disabledGlyphIcon = TextureCache.getTexture(TextureCache.X_SPRITE.enabled());
    private boolean selected;
    private boolean enabled = true;
    Button cfWebMapDownloadButton;
    Button mdWebMapDownloadButton;

    public CategorySlot(Category category) {
        this.category = category;
        boolean advanced = category == ClientCategory.Advanced || category == ClientCategory.AdvancedMapRendering;
        this.button = new Button(category.getLabel());
        this.cfWebMapDownloadButton = new Button("", button -> FullscreenActions.launchWebMapDownloadWebsite("https://www.curseforge.com/minecraft/mc-mods/journeymap-web-map"));
        this.mdWebMapDownloadButton = new Button("", button -> FullscreenActions.launchWebMapDownloadWebsite("https://modrinth.com/mod/journeymap-web-map"));
        this.metadata = new SlotMetadata(this.button, category.getLabel(), category.getTooltip(), advanced);
        this.updateButtonLabel();
    }

    public CategorySlot add(Slot slot) {
        if (this.enabled) {
            this.childSlots.add(slot);
            this.childMetadataList.addAll(slot.getMetadata());
            for (SlotMetadata slotMetadata : slot.getMetadata()) {
                if (!slotMetadata.isMasterPropertyForCategory()) continue;
                this.masterSlot = slotMetadata;
            }
        }
        return this;
    }

    public void clear() {
        this.childSlots.clear();
    }

    public int size() {
        return this.childSlots.size();
    }

    public void sort() {
        Collections.sort(this.childMetadataList);
    }

    @Override
    public int getColumnWidth() {
        int columnWidth = 100;
        for (Slot slot : this.childSlots) {
            columnWidth = Math.max(columnWidth, slot.getColumnWidth());
        }
        return columnWidth;
    }

    public List<Slot> getChildSlots(int listWidth, int columnWidth) {
        if (!this.selected || !this.enabled) {
            return Collections.EMPTY_LIST;
        }
        int columns = listWidth / (columnWidth + ButtonListSlot.hgap);
        if (columnWidth == this.currentColumnWidth && columns == this.currentColumns || columns == 0) {
            return this.childSlots;
        }
        this.currentListWidth = listWidth;
        this.currentColumnWidth = columnWidth;
        this.currentColumns = columns;
        this.childSlots.clear();
        this.sort();
        ArrayList<SlotMetadata> remaining = new ArrayList<SlotMetadata>(this.childMetadataList);
        while (!remaining.isEmpty()) {
            ButtonListSlot row = new ButtonListSlot(this);
            SlotMetadata.ValueType lastType = null;
            for (int i = 0; i < columns && !remaining.isEmpty(); ++i) {
                SlotMetadata.ValueType thisType = remaining.get((int)0).valueType;
                if (lastType == null && thisType == SlotMetadata.ValueType.Toolbar) {
                    row.addAll(remaining);
                    remaining.clear();
                    break;
                }
                if (lastType != null && lastType != thisType && (thisType == SlotMetadata.ValueType.Toolbar || lastType == SlotMetadata.ValueType.Boolean && remaining.size() > columns - i)) break;
                SlotMetadata column = remaining.remove(0);
                lastType = column.valueType;
                row.add(column);
            }
            row.buttons.setWidths(columnWidth);
            this.childSlots.add(row);
        }
        return this.childSlots;
    }

    @Override
    public Collection<SlotMetadata> getMetadata() {
        return Arrays.asList(this.metadata);
    }

    public List<SlotMetadata> getAllChildMetadata() {
        return this.childMetadataList;
    }

    public int getCurrentColumns() {
        return this.currentColumns;
    }

    public int getCurrentColumnWidth() {
        return this.currentColumnWidth;
    }

    public void render(GuiGraphics graphics, int slotIndex, int y, int x, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
        this.currentSlotIndex = slotIndex;
        this.button.setWidth(listWidth);
        this.button.setScrollablePosition(x, y);
        this.button.setHeight(slotHeight);
        this.button.render(graphics, mouseX, mouseY, 0.0f);
        DrawUtil.drawRectangle(graphics, this.button.getX() + 4, this.button.getMiddleY() - 5, 11.0, 10.0, 0, 0.2f);
        if (this.enabled) {
            DrawUtil.drawClampedImage(graphics.pose(), this.glyphIcon, this.button.getLabelColor(), 1.0f, this.button.getX() + (this.selected ? 5 : 6), (float)this.button.getMiddleY() - (float)((TextureAccess)this.glyphIcon).journeymap$getHeight() * 0.25f / 2.0f, 0.25f, this.selected ? 90.0 : 0.0);
        } else {
            DrawUtil.drawClampedImage(graphics.pose(), this.disabledGlyphIcon, 0xFF0000, 1.0f, this.button.getX() + 4, (float)this.button.getMiddleY() - (float)((TextureAccess)this.glyphIcon).journeymap$getHeight() * 0.35f / 2.0f, 0.35f, this.selected ? 90.0 : 0.0);
            if (ClientCategory.WebMap.equals(this.category)) {
                int labelWidth = Minecraft.getInstance().font.width(this.button.getLabel());
                int labelStart = this.button.getCenterX() - labelWidth / 2 - (slotHeight - 4);
                int labelEnd = this.button.getCenterX() + labelWidth / 2;
                this.renderWebMapDownloadButtons(graphics, this.cfWebMapDownloadButton, this.curseforgeTexutre, slotHeight, mouseX, mouseY, labelStart - 10, this.button.getY() + 2);
                this.renderWebMapDownloadButtons(graphics, this.mdWebMapDownloadButton, this.modrinthTexture, slotHeight, mouseX, mouseY, labelEnd + 10, this.button.getY() + 2);
            }
        }
        if (this.masterSlot != null && this.selected) {
            boolean enabled = this.masterSlot.button.isActive();
            for (Slot slot : this.childSlots) {
                slot.setEnabled(enabled);
            }
        }
        this.currentTooltip = null;
        if (!this.enabled && ClientCategory.WebMap.equals(this.category) && this.cfWebMapDownloadButton.mouseOver(mouseX, mouseY)) {
            this.currentTooltip = new SlotMetadata(this.cfWebMapDownloadButton, Constants.getString("jm.common.curseforge"), "https://www.curseforge.com/minecraft/mc-mods/journeymap-web-map", false);
        } else if (!this.enabled && ClientCategory.WebMap.equals(this.category) && this.mdWebMapDownloadButton.mouseOver(mouseX, mouseY)) {
            this.currentTooltip = new SlotMetadata(this.mdWebMapDownloadButton, Constants.getString("jm.common.modrinth"), "https://modrinth.com/mod/journeymap-web-map", false);
        } else if (this.button.mouseOver(mouseX, mouseY)) {
            this.currentTooltip = this.metadata;
        }
    }

    private void renderWebMapDownloadButtons(GuiGraphics graphics, Button button, DynamicTexture texture, int slotHeight, int mouseX, int mouseY, int pozX, int pozY) {
        button.setDefaultStyle(false);
        button.setDrawBackground(false);
        button.setDrawFrame(true);
        button.setScrollablePosition(pozX, pozY);
        button.setHeight(slotHeight - 4);
        button.setWidth(slotHeight - 4);
        button.render(graphics, mouseX, mouseY, 0.0f);
        DrawUtil.drawQuad(graphics.pose(), texture, button.getX() + 1, button.getY() + 1, button.getHeight() - 2, button.getWidth() - 2, false, 0.0);
        if (button.mouseOver(mouseX, mouseY)) {
            DrawUtil.drawRectangle(graphics, button.getX(), button.getY(), button.getHeight(), button.getWidth(), 65280, 0.15f);
        }
    }

    public boolean isMouseOver(double x, double y) {
        return super.isMouseOver(x, y);
    }

    private void updateButtonLabel() {
        this.button.setMessage((Component)Constants.getStringTextComponent(this.category.getLabel()));
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean mouseClicked(double x, double y, int mouseButton) {
        if (mouseButton == 0) {
            if (this.enabled) {
                boolean pressed = this.button.mouseClicked(x, y, mouseButton);
                if (pressed) {
                    this.setSelected(!this.selected);
                    this.updateButtonLabel();
                }
                return pressed;
            }
            if (ClientCategory.WebMap.equals(this.category) && this.cfWebMapDownloadButton.mouseOver(x, y)) {
                return this.cfWebMapDownloadButton.mouseClicked(x, y, mouseButton);
            }
            if (ClientCategory.WebMap.equals(this.category) && this.mdWebMapDownloadButton.mouseOver(x, y)) {
                return this.mdWebMapDownloadButton.mouseClicked(x, y, mouseButton);
            }
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double mouseDX, double mouseDY) {
        return false;
    }

    public boolean mouseReleased(double x, double y, int mouseButton) {
        return this.button.mouseReleased(x, y, mouseButton);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        return false;
    }

    public boolean keyPressed(int key, int value, int modifier) {
        return false;
    }

    @Override
    public int compareTo(CategorySlot other) {
        return this.category.compareTo(other.category);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.button.setEnabled(enabled);
    }

    @Override
    public SlotMetadata getLastPressed() {
        return this.metadata;
    }

    @Override
    public SlotMetadata getCurrentTooltip() {
        return this.currentTooltip;
    }

    @Override
    public boolean contains(SlotMetadata slotMetadata) {
        return this.childMetadataList.contains(slotMetadata);
    }

    public Category getCategory() {
        return this.category;
    }
}

