/*
 * Decompiled with CFR 0.152.
 */
package com.mcwfurnitures.kikoz.objects.chairs;

import com.mcwfurnitures.kikoz.MacawsFurnitures;
import com.mcwfurnitures.kikoz.objects.FurnitureObject;
import com.mcwfurnitures.kikoz.storage.ChairEntity;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ModernChair
extends FurnitureObject {
    private static final Map<Direction, VoxelShape> SHAPES = new EnumMap<Direction, VoxelShape>(Direction.class);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)2.0, (double)12.0, (double)12.0, (double)14.0, (double)18.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)15.0, (double)2.0), Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)2.0), Block.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)15.0, (double)16.0), Block.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)15.0, (double)16.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), Block.box((double)14.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)8.0, (double)0.1, (double)15.0, (double)10.0, (double)15.9), Block.box((double)2.0, (double)9.0, (double)1.0, (double)14.0, (double)12.0, (double)15.0)});

    protected void runCalculation(VoxelShape shape) {
        for (Direction direction : Direction.values()) {
            SHAPES.put(direction, MacawsFurnitures.calculateShapes(direction, shape));
        }
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    public ModernChair(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
        this.runCalculation(SHAPE);
    }

    protected ItemInteractionResult useItemOn(ItemStack itemstack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        return ChairEntity.create(level, pos, player);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }
}

