/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.util;

import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.ArrayUtils;

public final class ModLoaderUtil {
    public static void registerKeybind(KeyMapping keyBinding) {
        Minecraft.getInstance().options.keyMappings = (KeyMapping[])ArrayUtils.add((Object[])Minecraft.getInstance().options.keyMappings, (Object)keyBinding);
    }

    public static void registerClientTickListener(final Runnable runnable) {
        NeoForge.EVENT_BUS.addListener((Consumer)new Consumer<ClientTickEvent.Pre>(){

            @Override
            public void accept(ClientTickEvent.Pre t) {
                runnable.run();
            }
        });
    }

    public static boolean isModLoaded(String name) {
        return ModList.get().isLoaded(name);
    }

    public static void disableDisplayTest() {
    }

    public static void registerConfigScreen(Function<Screen, Screen> createScreen) {
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (mc, screen) -> (Screen)createScreen.apply(screen));
    }

    public static void registerClientSetupListener(final Runnable runnable) {
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener((Consumer)new Consumer<FMLClientSetupEvent>(){

            @Override
            public void accept(FMLClientSetupEvent t) {
                runnable.run();
            }
        });
    }

    public static <T extends Event> void registerForgeEvent(Consumer<T> handler) {
        NeoForge.EVENT_BUS.addListener(handler);
    }

    @Generated
    private ModLoaderUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

