/*
 * Decompiled with CFR 0.152.
 */
package dev.tonimatas.packetfixer.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;

public class Config {
    private static Properties properties = null;

    public static void runProperties() {
        try {
            File configFolder = new File("config");
            if (!configFolder.exists()) {
                configFolder.mkdirs();
            }
            File propertiesFile = new File(configFolder, "packetfixer.properties");
            properties = new Properties();
            if (!propertiesFile.exists()) {
                propertiesFile.createNewFile();
                properties.setProperty("allSizesUnlimited", "true");
                properties.setProperty("nbtMaxSize", Long.toString(0x200000L));
                properties.setProperty("packetSize", Integer.toString(0x100000));
                properties.setProperty("decoderSize", Integer.toString(0x800000));
                properties.setProperty("varInt21", Integer.toString(3));
                properties.setProperty("varInt", Integer.toString(5));
                properties.setProperty("varLong", Integer.toString(10));
                Config.checkVariable("chunkPacketData", Integer.toString(0x200000));
                properties.setProperty("timeout", Integer.toString(90));
                Config.save(propertiesFile);
            }
            properties.load(Files.newInputStream(propertiesFile.toPath(), new OpenOption[0]));
            Config.checkVariable("allSizesUnlimited", "true");
            Config.checkVariable("nbtMaxSize", Long.toString(0x200000L));
            Config.checkVariable("packetSize", Integer.toString(0x100000));
            Config.checkVariable("decoderSize", Integer.toString(0x800000));
            Config.checkVariable("varInt21", Integer.toString(3));
            Config.checkVariable("varInt", Integer.toString(5));
            Config.checkVariable("varLong", Integer.toString(10));
            Config.checkVariable("chunkPacketData", Integer.toString(0x200000));
            Config.checkVariable("timeout", Integer.toString(90));
            Config.save(propertiesFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean getUnlimitedPacketSize() {
        if (properties == null) {
            Config.runProperties();
        }
        return Boolean.parseBoolean(properties.getProperty("allSizesUnlimited"));
    }

    public static long getNbtMaxSize() {
        if (properties == null) {
            Config.runProperties();
        }
        return Config.getUnlimitedPacketSize() ? Long.MAX_VALUE : Long.parseLong(properties.getProperty("nbtMaxSize"));
    }

    public static int getPacketSize() {
        if (properties == null) {
            Config.runProperties();
        }
        return Config.getUnlimitedPacketSize() ? Integer.MAX_VALUE : Integer.parseInt(properties.getProperty("packetSize"));
    }

    public static int getDecoderSize() {
        if (properties == null) {
            Config.runProperties();
        }
        return Config.getUnlimitedPacketSize() ? Integer.MAX_VALUE : Integer.parseInt(properties.getProperty("decoderSize"));
    }

    public static int getVarInt21Size() {
        if (properties == null) {
            Config.runProperties();
        }
        return Config.getUnlimitedPacketSize() ? Integer.MAX_VALUE : Integer.parseInt(properties.getProperty("varInt21"));
    }

    public static int getVarIntSize() {
        if (properties == null) {
            Config.runProperties();
        }
        return Config.getUnlimitedPacketSize() ? Integer.MAX_VALUE : Integer.parseInt(properties.getProperty("varInt"));
    }

    public static int getVarLong() {
        if (properties == null) {
            Config.runProperties();
        }
        return Config.getUnlimitedPacketSize() ? Integer.MAX_VALUE : Integer.parseInt(properties.getProperty("varLong"));
    }

    public static int getChunkPacketData() {
        if (properties == null) {
            Config.runProperties();
        }
        return Config.getUnlimitedPacketSize() ? Integer.MAX_VALUE : Integer.parseInt(properties.getProperty("chunkPacketData"));
    }

    public static int getTimeout() {
        if (properties == null) {
            Config.runProperties();
        }
        return Integer.parseInt(properties.getProperty("timeout"));
    }

    private static void checkVariable(String variable, String defaultValue) {
        if (properties.getProperty(variable) == null) {
            properties.setProperty(variable, defaultValue);
        }
    }

    private static void save(File propertiesFile) throws IOException {
        properties.store(Files.newOutputStream(propertiesFile.toPath(), new OpenOption[0]), "Packet Fixer config file.\nDefault values (minecraft default): nbtMaxSize 2097152, packetSize 1048576, decoderSize 8388608 and varInt21Size 3.\nMax values are 2147483647 for packetSize/decoderSize/varInt21 and 9223372036854775807 for nbtMaxSize.");
    }
}

