/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.crafting;

import com.flanks255.simplybackpacks.SimplyBackpacks;
import com.flanks255.simplybackpacks.items.BackpackItem;
import com.mojang.serialization.MapCodec;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import org.jetbrains.annotations.NotNull;

public class CopyBackpackDataRecipe
extends ShapedRecipe {
    public CopyBackpackDataRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack recipeOutput) {
        super(group, category, pattern, recipeOutput);
    }

    public CopyBackpackDataRecipe(ShapedRecipe shapedRecipe) {
        super(shapedRecipe.getGroup(), shapedRecipe.category(), shapedRecipe.pattern, shapedRecipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY));
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingInput inv, @Nonnull HolderLookup.Provider provider) {
        ItemStack craftingResult = super.assemble(inv, provider);
        ItemStack dataSource = ItemStack.EMPTY;
        if (!craftingResult.isEmpty()) {
            for (int i = 0; i < inv.size(); ++i) {
                ItemStack item = inv.getItem(i);
                if (item.isEmpty() || !(item.getItem() instanceof BackpackItem)) continue;
                dataSource = item;
                break;
            }
            if (!dataSource.isEmpty()) {
                if (dataSource.has((DataComponentType)SimplyBackpacks.BACKPACK_UUID.get())) {
                    craftingResult.set((DataComponentType)SimplyBackpacks.BACKPACK_UUID.get(), (Object)((UUID)dataSource.get((DataComponentType)SimplyBackpacks.BACKPACK_UUID.get())));
                } else if (dataSource.has(DataComponents.CUSTOM_DATA) && ((CustomData)dataSource.get(DataComponents.CUSTOM_DATA)).contains("UUID")) {
                    craftingResult.set((DataComponentType)SimplyBackpacks.BACKPACK_UUID.get(), (Object)((CustomData)dataSource.get(DataComponents.CUSTOM_DATA)).copyTag().getUUID("UUID"));
                }
            }
        }
        return craftingResult;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SimplyBackpacks.COPYRECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<CopyBackpackDataRecipe> {
        private static final MapCodec<CopyBackpackDataRecipe> CODEC = ShapedRecipe.Serializer.CODEC.xmap(CopyBackpackDataRecipe::new, $ -> $);
        private static final StreamCodec<RegistryFriendlyByteBuf, CopyBackpackDataRecipe> STREAM_CODEC = RecipeSerializer.SHAPED_RECIPE.streamCodec().map(CopyBackpackDataRecipe::new, CopyBackpackDataRecipe::new);

        @NotNull
        public MapCodec<CopyBackpackDataRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, CopyBackpackDataRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

