/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.gui;

import com.flanks255.simplybackpacks.gui.FilterContainer;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class FilterGui
extends AbstractContainerScreen<FilterContainer> {
    private final Inventory inventory;
    private final ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"simplybackpacks", (String)"textures/gui/filter_gui.png");

    public FilterGui(FilterContainer container, Inventory playerInventory, Component name) {
        super((AbstractContainerMenu)container, playerInventory, name);
        this.inventory = playerInventory;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void init() {
        super.init();
        Button.OnPress slotClick = button -> {
            Minecraft.getInstance().gameMode.handleInventoryButtonClick(((FilterContainer)this.menu).containerId, ((SlotButton)button).slot);
            ((FilterContainer)this.menu).clickMenuButton(this.inventory.player, ((SlotButton)button).slot);
        };
        int slot = 0;
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 4; ++col) {
                int x = this.leftPos + 7 + col * 18;
                int y = this.topPos + 7 + row * 18;
                this.addRenderableWidget((GuiEventListener)new SlotButton(x + 1, y + 1, 18, 18, slot, slotClick));
                ++slot;
            }
        }
        this.addRenderableWidget((GuiEventListener)new SwitchButton(this.leftPos + 80, this.topPos + 8, "simplybackpacks.whitelist", (((FilterContainer)this.menu).getFilterOpts() & 1) > 0, button -> {
            ((SwitchButton)button).state = (((FilterContainer)this.menu).saveFilterClient(((FilterContainer)this.menu).getFilterOpts() ^ 1) & 1) > 0;
        }));
        this.addRenderableWidget((GuiEventListener)new SwitchButton(this.leftPos + 80, this.topPos + 8 + 18, "simplybackpacks.nbtdata", (((FilterContainer)this.menu).getFilterOpts() & 2) > 0, button -> {
            ((SwitchButton)button).state = (((FilterContainer)this.menu).saveFilterClient(((FilterContainer)this.menu).getFilterOpts() ^ 2) & 2) > 0;
        }));
        this.addRenderableWidget((GuiEventListener)new SwitchButton(this.leftPos + 80, this.topPos + 8 + 54, "simplybackpacks.autopickup", ((FilterContainer)this.menu).getPickup(), button -> {
            ((SwitchButton)button).state = ((FilterContainer)this.menu).togglePickup();
        }));
    }

    public void render(@Nonnull GuiGraphics gg, int p_render_1_, int p_render_2_, float p_render_3_) {
        this.renderBackground(gg, p_render_1_, p_render_2_, p_render_3_);
        super.render(gg, p_render_1_, p_render_2_, p_render_3_);
        this.renderTooltip(gg, p_render_1_, p_render_2_);
    }

    protected void renderBg(@Nonnull GuiGraphics gui, float partialTicks, int x, int y) {
        gui.blit(this.GUI, this.leftPos, this.topPos, 0.0f, 0.0f, 176, 166, 176, 166);
    }

    protected void renderLabels(@Nonnull GuiGraphics gg, int x, int y) {
    }

    protected void renderTooltip(@Nonnull GuiGraphics gg, int x, int y) {
        super.renderTooltip(gg, x, y);
        this.children().forEach(child -> {
            if (child.isMouseOver((double)x, (double)y) && child instanceof SlotButton) {
                SlotButton button = (SlotButton)((Object)child);
                if (!((FilterContainer)this.menu).filterHandler.getStackInSlot(button.slot).isEmpty()) {
                    gg.renderTooltip(this.font, ((FilterContainer)this.menu).filterHandler.getStackInSlot(button.slot), x, y);
                }
            }
        });
    }

    class SlotButton
    extends Button {
        public final int slot;

        public SlotButton(int x, int y, int width, int height, int slotIn, Button.OnPress pressable) {
            super(x, y, width, height, (Component)Component.empty(), pressable, Button.DEFAULT_NARRATION);
            this.slot = slotIn;
        }

        public void renderWidget(@Nonnull GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
            boolean hovered;
            boolean bl = hovered = mouseX >= this.getX() && mouseX < this.getX() + this.width && mouseY >= this.getY() && mouseY < this.getY() + this.height;
            if (((FilterContainer)((FilterGui)FilterGui.this).menu).filterHandler != null && !((FilterContainer)((FilterGui)FilterGui.this).menu).filterHandler.getStackInSlot(this.slot).isEmpty()) {
                ItemStack tmp = ((FilterContainer)((FilterGui)FilterGui.this).menu).filterHandler.getStackInSlot(this.slot);
                RenderSystem.enableDepthTest();
                Lighting.setupForFlatItems();
                gg.renderItem(tmp, this.getX(), this.getY());
                Lighting.setupFor3DItems();
                RenderSystem.disableDepthTest();
            }
            if (hovered) {
                gg.fill(this.getX(), this.getY(), this.getX() + this.width - 1, this.getY() + this.height - 1, -2130706433);
            }
        }
    }

    class SwitchButton
    extends Button {
        private static final ResourceLocation off = ResourceLocation.fromNamespaceAndPath((String)"simplybackpacks", (String)"textures/gui/switch_off.png");
        private static final ResourceLocation on = ResourceLocation.fromNamespaceAndPath((String)"simplybackpacks", (String)"textures/gui/switch_on.png");
        public boolean state;
        private final String textKey;

        public SwitchButton(int x, int y, String text, boolean initial, Button.OnPress pressable) {
            super(x, y, 32, 16, (Component)Component.empty(), pressable, Button.DEFAULT_NARRATION);
            this.textKey = text;
            this.state = initial;
        }

        public void renderWidget(@Nonnull GuiGraphics gg, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
            gg.blit(this.state ? on : off, this.getX(), this.getY(), this.width, this.height, 0.0f, 0.0f, 32, 16, 32, 16);
            gg.drawString(FilterGui.this.font, I18n.get((String)this.textKey, (Object[])new Object[0]), this.getX() + 34, this.getY() + 4, 0x404040, false);
        }
    }
}

