/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.inventory;

import com.flanks255.simplybackpacks.inventory.FilterItemHandler;
import com.flanks255.simplybackpacks.inventory.SBItemHandler;
import com.flanks255.simplybackpacks.items.Backpack;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;

public class BackpackData {
    private final UUID uuid;
    private Backpack tier;
    private final SBItemHandler inventory;
    private final Optional<IItemHandler> optional;
    public final Metadata meta = new Metadata();
    private FilterItemHandler filter = new FilterItemHandler();

    public Optional<IItemHandler> getOptional() {
        return this.optional;
    }

    public IItemHandler getHandler() {
        return this.inventory;
    }

    public FilterItemHandler getFilter() {
        return this.filter;
    }

    public Backpack getTier() {
        return this.tier;
    }

    public void updateAccessRecords(String player, long time) {
        if (this.meta.firstAccessedTime == 0L) {
            this.meta.firstAccessedTime = time;
            this.meta.firstAccessedPlayer = player;
        }
        this.meta.setLastAccessedTime(time);
        this.meta.setLastAccessedPlayer(player);
    }

    public BackpackData(UUID uuid, Backpack tier) {
        this.uuid = uuid;
        this.tier = tier;
        this.inventory = new SBItemHandler(tier.slots);
        this.optional = Optional.of(this.inventory);
    }

    public BackpackData(UUID uuid, CompoundTag incomingNBT, HolderLookup.Provider pRegistries) {
        this.uuid = uuid;
        this.tier = Backpack.values()[Math.min(incomingNBT.getInt("Tier"), Backpack.ULTIMATE.ordinal())];
        this.inventory = new SBItemHandler(this.tier.slots);
        if (incomingNBT.getCompound("Inventory").contains("Size") && incomingNBT.getCompound("Inventory").getInt("Size") != this.tier.slots) {
            incomingNBT.getCompound("Inventory").putInt("Size", this.tier.slots);
        }
        this.inventory.deserializeNBT(pRegistries, incomingNBT.getCompound("Inventory"));
        this.filter = new FilterItemHandler();
        this.filter.deserializeNBT(pRegistries, incomingNBT.getCompound("Filter"));
        this.optional = Optional.of(this.inventory);
        if (incomingNBT.contains("Metadata")) {
            this.meta.deserializeNBT((HolderLookup.Provider)RegistryAccess.EMPTY, incomingNBT.getCompound("Metadata"));
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public static Optional<BackpackData> fromNBT(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        if (nbt.contains("UUID")) {
            UUID uuid = nbt.getUUID("UUID");
            return Optional.of(new BackpackData(uuid, nbt, pRegistries));
        }
        return Optional.empty();
    }

    public void upgrade(Backpack newTier) {
        if (newTier.ordinal() > this.tier.ordinal()) {
            this.tier = newTier;
            this.inventory.upgrade(this.tier.slots);
        }
    }

    public CompoundTag toNBT(HolderLookup.Provider pRegistries) {
        CompoundTag nbt = new CompoundTag();
        nbt.putUUID("UUID", this.uuid);
        nbt.putInt("Tier", this.tier.ordinal());
        nbt.put("Inventory", (Tag)this.inventory.serializeNBT(pRegistries));
        nbt.put("Filter", (Tag)this.filter.serializeNBT(pRegistries));
        nbt.put("Metadata", (Tag)this.meta.serializeNBT((HolderLookup.Provider)RegistryAccess.EMPTY));
        return nbt;
    }

    public static class Metadata
    implements INBTSerializable<CompoundTag> {
        private String firstAccessedPlayer = "";
        private long firstAccessedTime = 0L;
        private String lastAccessedPlayer = "";
        private long lastAccessedTime = 0L;

        public long getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        public void setLastAccessedTime(long lastAccessedTime) {
            this.lastAccessedTime = lastAccessedTime;
        }

        public String getLastAccessedPlayer() {
            return this.lastAccessedPlayer;
        }

        public void setLastAccessedPlayer(String lastAccessedPlayer) {
            this.lastAccessedPlayer = lastAccessedPlayer;
        }

        public long getFirstAccessedTime() {
            return this.firstAccessedTime;
        }

        public String getFirstAccessedPlayer() {
            return this.firstAccessedPlayer;
        }

        public CompoundTag serializeNBT(HolderLookup.Provider pRegistries) {
            CompoundTag nbt = new CompoundTag();
            nbt.putString("firstPlayer", this.firstAccessedPlayer);
            nbt.putLong("firstTime", this.firstAccessedTime);
            nbt.putString("lastPlayer", this.lastAccessedPlayer);
            nbt.putLong("lastTime", this.lastAccessedTime);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider pRegistries, CompoundTag nbt) {
            this.firstAccessedPlayer = nbt.getString("firstPlayer");
            this.firstAccessedTime = nbt.getLong("firstTime");
            this.lastAccessedPlayer = nbt.getString("lastPlayer");
            this.lastAccessedTime = nbt.getLong("lastTime");
        }
    }
}

