/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.items;

import com.flanks255.simplybackpacks.SimplyBackpacks;
import com.flanks255.simplybackpacks.gui.FilterContainer;
import com.flanks255.simplybackpacks.gui.SBContainer;
import com.flanks255.simplybackpacks.inventory.BackpackData;
import com.flanks255.simplybackpacks.inventory.BackpackManager;
import com.flanks255.simplybackpacks.inventory.FilterItemHandler;
import com.flanks255.simplybackpacks.inventory.SBItemHandler;
import com.flanks255.simplybackpacks.items.Backpack;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.items.IItemHandler;

public class BackpackItem
extends Item {
    final String name;
    final Backpack tier;
    private static final Random random = new Random();

    public BackpackItem(String name, Backpack tier) {
        super(new Item.Properties().stacksTo(1).fireResistant().rarity(tier.rarity));
        this.name = name;
        this.tier = tier;
    }

    public static Backpack getTier(ItemStack stack) {
        if (!stack.isEmpty() && stack.getItem() instanceof BackpackItem) {
            return ((BackpackItem)stack.getItem()).tier;
        }
        return Backpack.COMMON;
    }

    public static BackpackData getData(ItemStack stack) {
        UUID uuid;
        if (!(stack.getItem() instanceof BackpackItem)) {
            return null;
        }
        if (stack.has(SimplyBackpacks.BACKPACK_UUID)) {
            uuid = (UUID)stack.get(SimplyBackpacks.BACKPACK_UUID);
        } else if (stack.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag tag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
            if (tag.contains("UUID")) {
                uuid = tag.getUUID("UUID");
                stack.set(SimplyBackpacks.BACKPACK_UUID, (Object)uuid);
                stack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, $ -> $.update(compoundTag -> compoundTag.remove("UUID")));
            } else {
                uuid = UUID.randomUUID();
                stack.set(SimplyBackpacks.BACKPACK_UUID, (Object)uuid);
            }
        } else {
            uuid = UUID.randomUUID();
            stack.set(SimplyBackpacks.BACKPACK_UUID, (Object)uuid);
        }
        return BackpackManager.get().getOrCreateBackpack(uuid, ((BackpackItem)stack.getItem()).tier);
    }

    public static boolean isBackpack(ItemStack stack) {
        return stack.getItem() instanceof BackpackItem;
    }

    @Nonnull
    public Component getDescription() {
        return Component.translatable((String)this.getDescriptionId()).withStyle(this.tier == Backpack.ULTIMATE ? ChatFormatting.DARK_AQUA : ChatFormatting.RESET);
    }

    public boolean isEnchantable(@Nonnull ItemStack stack) {
        return false;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        ItemStack backpack = playerIn.getItemInHand(handIn);
        if (!worldIn.isClientSide && playerIn instanceof ServerPlayer && backpack.getItem() instanceof BackpackItem) {
            BackpackData data = BackpackItem.getData(backpack);
            Backpack itemTier = ((BackpackItem)backpack.getItem()).tier;
            UUID uuid = data.getUuid();
            data.updateAccessRecords(playerIn.getName().getString(), System.currentTimeMillis());
            if (data.getTier().ordinal() < itemTier.ordinal()) {
                data.upgrade(itemTier);
                playerIn.sendSystemMessage((Component)Component.literal((String)("Backpack upgraded to " + itemTier.name)));
            }
            if (playerIn.isShiftKeyDown()) {
                playerIn.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new FilterContainer(windowId, playerInventory, data.getFilter()), backpack.getHoverName()), buffer -> buffer.writeNbt((Tag)data.getFilter().serializeNBT((HolderLookup.Provider)worldIn.registryAccess())));
            } else {
                playerIn.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new SBContainer(windowId, playerInventory, uuid, data.getTier(), data.getHandler()), backpack.getHoverName()), buffer -> buffer.writeUUID(uuid).writeInt(data.getTier().ordinal()));
            }
        }
        return InteractionResultHolder.success((Object)playerIn.getItemInHand(handIn));
    }

    public static void togglePickup(Player playerEntity, ItemStack stack) {
        boolean Pickup = (Boolean)stack.getOrDefault(SimplyBackpacks.BACKPACK_PICKUP, (Object)false) == false;
        stack.set(SimplyBackpacks.BACKPACK_PICKUP, (Object)Pickup);
        if (playerEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
            serverPlayer.displayClientMessage((Component)Component.translatable((String)(Pickup ? "simplybackpacks.autopickupenabled" : "simplybackpacks.autopickupdisabled")), true);
        } else {
            playerEntity.displayClientMessage((Component)Component.translatable((String)(Pickup ? "simplybackpacks.autopickupenabled" : "simplybackpacks.autopickupdisabled")), true);
        }
    }

    public static boolean applyFilter(ItemStack item, ItemStack packItem) {
        Optional<IItemHandler> handler = Optional.ofNullable((IItemHandler)packItem.getCapability(Capabilities.ItemHandler.ITEM));
        if (handler.isPresent() && handler.get() instanceof SBItemHandler) {
            BackpackData data = BackpackItem.getData(packItem);
            if (data == null) {
                return false;
            }
            FilterItemHandler filterHandler = data.getFilter();
            int filterOpts = (Integer)packItem.getOrDefault(SimplyBackpacks.BACKPACK_FILTER, (Object)0);
            boolean whitelist = (filterOpts & 1) > 0;
            boolean nbtMatch = (filterOpts & 2) > 0;
            for (int i = 0; i < 16; ++i) {
                ItemStack fStack = filterHandler.getStackInSlot(i);
                if (fStack.isEmpty() || !ItemStack.isSameItem((ItemStack)fStack, (ItemStack)item)) continue;
                if (nbtMatch) {
                    return ItemStack.isSameItemSameComponents((ItemStack)fStack, (ItemStack)item) == whitelist;
                }
                return whitelist;
            }
            return !whitelist;
        }
        return false;
    }

    public static boolean pickupEvent(ItemEntityPickupEvent.Pre event, ItemStack stack) {
        if (!((Boolean)stack.getOrDefault(SimplyBackpacks.BACKPACK_PICKUP, (Object)false)).booleanValue()) {
            return false;
        }
        Optional<IItemHandler> optional = Optional.ofNullable((IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM));
        if (optional.isPresent()) {
            IItemHandler handler = optional.get();
            if (!(handler instanceof SBItemHandler)) {
                return false;
            }
            if (!BackpackItem.applyFilter(event.getItemEntity().getItem(), stack)) {
                return false;
            }
            ItemStack pickedUp = event.getItemEntity().getItem();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack slot = handler.getStackInSlot(i);
                if (!slot.isEmpty() && (!ItemStack.isSameItemSameComponents((ItemStack)slot, (ItemStack)pickedUp) || slot.getCount() >= slot.getMaxStackSize() || slot.getCount() >= handler.getSlotLimit(i))) continue;
                int remainder = handler.insertItem(i, pickedUp.copy(), false).getCount();
                pickedUp.setCount(remainder);
                if (remainder == 0) break;
            }
            if (pickedUp.isEmpty()) {
                event.getPlayer().level().playSound(null, event.getPlayer().blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((random.nextFloat() - random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            return pickedUp.isEmpty();
        }
        return false;
    }

    private boolean hasTranslation(String key) {
        return !I18n.get((String)key, (Object[])new Object[0]).equals(key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        String translationKey = this.getDescriptionId();
        if (!stack.has(SimplyBackpacks.BACKPACK_UUID)) {
            tooltip.add((Component)Component.translatable((String)"simplybackpacks.notsetup").withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.GOLD));
        }
        if (stack.has(SimplyBackpacks.BACKPACK_PICKUP)) {
            boolean pickupEnabled = (Boolean)stack.get(SimplyBackpacks.BACKPACK_PICKUP);
            if (pickupEnabled) {
                tooltip.add((Component)Component.translatable((String)"simplybackpacks.autopickupenabled"));
            } else {
                tooltip.add((Component)Component.translatable((String)"simplybackpacks.autopickupdisabled"));
            }
        }
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)(translationKey + ".info")));
            if (this.hasTranslation(translationKey + ".info2")) {
                tooltip.add((Component)Component.translatable((String)(translationKey + ".info2")));
            }
            if (this.hasTranslation(translationKey + ".info3")) {
                tooltip.add((Component)Component.translatable((String)(translationKey + ".info3")));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"simplybackpacks.shift"));
        }
        if (flagIn.isAdvanced() && stack.has(SimplyBackpacks.BACKPACK_UUID)) {
            UUID uuid = (UUID)stack.get(SimplyBackpacks.BACKPACK_UUID);
            tooltip.add((Component)Component.literal((String)("ID: " + uuid.toString().substring(0, 8))).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else if (flagIn.isAdvanced() && stack.has(DataComponents.CUSTOM_DATA) && ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).contains("UUID")) {
            UUID uuid = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).getUnsafe().getUUID("UUID");
            tooltip.add((Component)Component.literal((String)("ID: " + uuid.toString().substring(0, 8))).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }
}

