/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.util;

import com.flanks255.simplybackpacks.SimplyBackpacks;
import com.flanks255.simplybackpacks.configuration.ConfigCache;
import com.flanks255.simplybackpacks.inventory.BackpackManager;
import com.flanks255.simplybackpacks.items.BackpackItem;
import com.flanks255.simplybackpacks.util.People;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class BackpackUtils {
    public static boolean curiosLoaded = false;
    private static final HashMap<String, Confirmation> confirmationMap = new HashMap();

    public static ResourceLocation getRegistryName(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public static boolean filterItem(ItemStack stack) {
        if (ConfigCache.WHITELIST.contains(BackpackUtils.getRegistryName(stack.getItem()))) {
            return true;
        }
        if (stack.is(SimplyBackpacks.HOLDS_ITEMS)) {
            return false;
        }
        if (!stack.getItem().canFitInsideContainerItems()) {
            return false;
        }
        return !ConfigCache.BLACKLIST.contains(BackpackUtils.getRegistryName(stack.getItem()));
    }

    public static ItemStack findBackpackForHotkeys(Player player, boolean includeHands) {
        ItemStack stack;
        Optional curiosInv;
        if (includeHands && player.getMainHandItem().getItem() instanceof BackpackItem) {
            return player.getMainHandItem();
        }
        if (includeHands && player.getOffhandItem().getItem() instanceof BackpackItem) {
            return player.getOffhandItem();
        }
        if (curiosLoaded && (curiosInv = CuriosApi.getCuriosInventory((LivingEntity)player)).isPresent() && !(stack = ((ICuriosItemHandler)curiosInv.get()).findFirstCurio(BackpackItem::isBackpack).map(slot -> {
            if (slot.stack().getItem() instanceof BackpackItem) {
                return slot.stack();
            }
            return ItemStack.EMPTY;
        }).orElse(ItemStack.EMPTY)).isEmpty()) {
            return stack;
        }
        Inventory inventory = player.getInventory();
        for (int i = 0; i <= 35; ++i) {
            ItemStack stack2 = inventory.getItem(i);
            if (!(stack2.getItem() instanceof BackpackItem)) continue;
            return stack2;
        }
        return ItemStack.EMPTY;
    }

    @Nonnull
    public static Optional<UUID> getUUID(@Nonnull ItemStack stack) {
        if (stack.has(SimplyBackpacks.BACKPACK_UUID)) {
            return Optional.ofNullable((UUID)stack.get(SimplyBackpacks.BACKPACK_UUID));
        }
        if (stack.getItem() instanceof BackpackItem && stack.has(DataComponents.CUSTOM_DATA) && ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).contains("UUID")) {
            return Optional.of(((CustomData)stack.get(DataComponents.CUSTOM_DATA)).getUnsafe().getUUID("UUID"));
        }
        return Optional.empty();
    }

    public static Set<String> getUUIDSuggestions(CommandContext<CommandSourceStack> commandSource) {
        BackpackManager backpacks = BackpackManager.get();
        HashSet<String> list = new HashSet<String>();
        backpacks.getMap().forEach((uuid, backpackData) -> list.add(uuid.toString()));
        return list;
    }

    public static boolean increasedAltChance(UUID uuidIn) {
        if (uuidIn.compareTo(People.FLANKS255) == 0) {
            return true;
        }
        if (uuidIn.compareTo(People.ELLPECK) == 0) {
            return true;
        }
        return uuidIn.compareTo(People.LONEZTAR) == 0;
    }

    public static String generateCode(RandomSource random) {
        return "%08x".formatted(random.nextInt(Integer.MAX_VALUE));
    }

    public static void addConfirmation(String code, UUID player, UUID backpack) {
        confirmationMap.put(code, new Confirmation(code, player, backpack));
    }

    public static void removeConfirmation(String code) {
        confirmationMap.remove(code);
    }

    public static Optional<Confirmation> getConfirmation(String code) {
        return Optional.ofNullable(confirmationMap.get(code));
    }

    public static boolean isValidResourceLocation(String string) {
        return ResourceLocation.tryParse((String)string) != null;
    }

    public record Confirmation(String code, UUID player, UUID backpack) {
    }
}

