/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.client.gui.scrollable_page;

import java.util.ArrayList;
import java.util.List;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFrame
extends AbstractWidget
implements ContainerEventHandler {
    protected final Dim2i dim;
    protected final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
    protected final List<ControlElement<?>> controlElements = new ArrayList();
    private GuiEventListener focused;
    private boolean dragging;

    public AbstractFrame(Dim2i dim) {
        this.dim = dim;
    }

    public void buildFrame() {
        for (GuiEventListener guiEventListener : this.children) {
            if (guiEventListener instanceof AbstractFrame) {
                AbstractFrame abstractFrame = (AbstractFrame)guiEventListener;
                this.controlElements.addAll(abstractFrame.controlElements);
            }
            if (!(guiEventListener instanceof ControlElement)) continue;
            this.controlElements.add((ControlElement)guiEventListener);
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        for (Renderable renderable : this.children) {
            renderable.render(guiGraphics, mouseX, mouseY, delta);
        }
    }

    public void applyScissor(@NotNull GuiGraphics guiGraphics, int x, int y, int width, int height, Runnable action) {
        guiGraphics.enableScissor(x, y, x + width, y + height);
        action.run();
        guiGraphics.disableScissor();
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.focused;
    }

    public void setFocused(@Nullable GuiEventListener focused) {
        this.focused = focused;
    }

    public List<? extends GuiEventListener> children() {
        return this.children;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.dim.containsCursor(mouseX, mouseY);
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent navigation) {
        return super.nextFocusPath(navigation);
    }

    public ScreenRectangle getRectangle() {
        return new ScreenRectangle(this.dim.x(), this.dim.y(), this.dim.width(), this.dim.height());
    }
}

