/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.waveycapes;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.waveycapes.NMSUtil;
import dev.tr7zw.waveycapes.config.CustomConfigScreen;
import dev.tr7zw.waveycapes.delegate.PlayerDelegate;
import dev.tr7zw.waveycapes.support.AnimationSupport;
import dev.tr7zw.waveycapes.support.SupportManager;
import dev.tr7zw.waveycapes.util.NMSHelper;
import dev.tr7zw.waveycapes.versionless.CapeMovement;
import dev.tr7zw.waveycapes.versionless.CapeStyle;
import dev.tr7zw.waveycapes.versionless.ModBase;
import dev.tr7zw.waveycapes.versionless.WindMode;
import dev.tr7zw.waveycapes.versionless.config.Config;
import dev.tr7zw.waveycapes.versionless.nms.MinecraftPlayer;
import dev.tr7zw.waveycapes.versionless.util.Vector3;
import java.util.ArrayList;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class WaveyCapesBase
extends ModBase {
    public static WaveyCapesBase INSTANCE;

    @Override
    public void init() {
        INSTANCE = this;
        super.init();
        this.initSupportHooks();
    }

    @Override
    public Vector3 applyModAnimations(MinecraftPlayer player, Vector3 pos) {
        for (AnimationSupport sup : SupportManager.animationSupport) {
            pos = sup.applyAnimationChanges(((PlayerDelegate)player).getPlayer(), 0.0f, pos);
        }
        return pos;
    }

    public Screen createConfigScreen(Screen parent) {
        return new CustomConfigScreen(parent, "text.wc.title"){
            private int rotationX;
            private int rotationY;
            {
                this.rotationX = 164;
                this.rotationY = 5;
            }

            @Override
            public void initialize() {
                ArrayList<Object> options = new ArrayList<Object>();
                options.add(this.getEnumOption("text.wc.setting.capestyle", CapeStyle.class, () -> ModBase.config.capeStyle, v -> {
                    ModBase.config.capeStyle = v;
                }));
                options.add(this.getEnumOption("text.wc.setting.windmode", WindMode.class, () -> ModBase.config.windMode, v -> {
                    ModBase.config.windMode = v;
                }));
                options.add(this.getEnumOption("text.wc.setting.capemovement", CapeMovement.class, () -> ModBase.config.capeMovement, v -> {
                    ModBase.config.capeMovement = v;
                }));
                options.add(this.getIntOption("text.wc.setting.gravity", 5, 32, () -> ModBase.config.gravity, v -> {
                    ModBase.config.gravity = v;
                }));
                options.add(this.getIntOption("text.wc.setting.heightMultiplier", 4, 16, () -> ModBase.config.heightMultiplier, v -> {
                    ModBase.config.heightMultiplier = v;
                }));
                this.getOptions().addSmall(options.toArray(new OptionInstance[0]));
            }

            @Override
            public void save() {
                WaveyCapesBase.this.writeConfig();
            }

            public boolean keyPressed(int i, int j, int k) {
                if (i == 263) {
                    --this.rotationX;
                }
                if (i == 262) {
                    ++this.rotationX;
                }
                if (i == 264) {
                    --this.rotationY;
                }
                if (i == 265) {
                    ++this.rotationY;
                }
                return super.keyPressed(i, j, k);
            }

            @Override
            public void render(GuiGraphics guiGraphics, int xMouse, int yMouse, float f) {
                super.render(guiGraphics, xMouse, yMouse, f);
                if (this.minecraft.level != null) {
                    int x = this.minecraft.getWindow().getGuiScaledWidth() / 2;
                    int y = this.minecraft.getWindow().getGuiScaledHeight() - this.minecraft.getWindow().getGuiScaledHeight() / 3;
                    int size = (int)(40.0f * ((float)this.minecraft.getWindow().getGuiScaledHeight() / 200.0f));
                    WaveyCapesBase.this.drawEntity(x, y, size, this.rotationX, this.rotationY, (LivingEntity)this.minecraft.player, f);
                }
            }

            @Override
            public void reset() {
                ModBase.config = new Config();
                WaveyCapesBase.this.writeConfig();
            }
        };
    }

    private void drawEntity(int x, int y, int size, float lookX, float lookY, LivingEntity livingEntity, float delta) {
        float rotationModifyer = 3.0f;
        NMSUtil.prepareViewMatrix(x, y);
        PoseStack matrixStack = new PoseStack();
        matrixStack.translate((double)x, (double)y, 1000.0);
        matrixStack.scale((float)size, (float)size, (float)size);
        matrixStack.scale(1.0f, 1.0f, -1.0f);
        Quaternionf quaternion = NMSHelper.ZP.rotationDegrees(180.0f);
        Quaternionf quaternion2 = NMSHelper.XP.rotationDegrees(lookY * rotationModifyer);
        quaternion.mul((Quaternionfc)quaternion2);
        matrixStack.mulPose(quaternion);
        matrixStack.translate(0.0, -1.0, 0.0);
        float yBodyRot = livingEntity.yBodyRot;
        float yRot = NMSHelper.getYRot((Entity)livingEntity);
        float yRotO = livingEntity.yRotO;
        float yBodyRotO = livingEntity.yBodyRotO;
        float xRot = NMSHelper.getXRot((Entity)livingEntity);
        float xRotO = livingEntity.xRotO;
        float yHeadRotO = livingEntity.yHeadRotO;
        float yHeadRot = livingEntity.yHeadRot;
        Vec3 vel = livingEntity.getDeltaMovement();
        livingEntity.yBodyRot = 180.0f + lookX * rotationModifyer;
        NMSHelper.setYRot((Entity)livingEntity, 180.0f + lookX * rotationModifyer);
        livingEntity.yBodyRotO = livingEntity.yBodyRot;
        livingEntity.yRotO = NMSHelper.getYRot((Entity)livingEntity);
        livingEntity.setDeltaMovement(Vec3.ZERO);
        NMSHelper.setXRot((Entity)livingEntity, 0.0f);
        livingEntity.xRotO = NMSHelper.getXRot((Entity)livingEntity);
        livingEntity.yHeadRot = NMSHelper.getYRot((Entity)livingEntity);
        livingEntity.yHeadRotO = NMSHelper.getYRot((Entity)livingEntity);
        NMSUtil.prepareLighting();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        NMSUtil.conjugate(quaternion2);
        entityRenderDispatcher.overrideCameraOrientation(quaternion2);
        entityRenderDispatcher.setRenderShadow(false);
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        entityRenderDispatcher.render((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, delta, matrixStack, (MultiBufferSource)bufferSource, 0xF000F0);
        bufferSource.endBatch();
        entityRenderDispatcher.setRenderShadow(true);
        livingEntity.yBodyRot = yBodyRot;
        livingEntity.yBodyRotO = yBodyRotO;
        NMSHelper.setYRot((Entity)livingEntity, yRot);
        livingEntity.yRotO = yRotO;
        NMSHelper.setXRot((Entity)livingEntity, xRot);
        livingEntity.xRotO = xRotO;
        livingEntity.yHeadRotO = yHeadRotO;
        livingEntity.yHeadRot = yHeadRot;
        livingEntity.setDeltaMovement(vel);
        NMSUtil.resetViewMatrix();
        Lighting.setupFor3DItems();
    }

    @Override
    public void initSupportHooks() {
    }

    @Generated
    public static WaveyCapesBase getINSTANCE() {
        return INSTANCE;
    }
}

