package ru.vizzi.draconicaddons.packet;

import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.SerializerMark;
import io.netty.buffer.ByteBuf;

@SerializerMark(
    packetClass = ru.vizzi.draconicaddons.packet.PacketData.class
)
public class PacketDataSerializer implements ISerializer<PacketData> {
  public void serialize(PacketData value, ByteBuf acc) {
    serialize_PacketData_Generic(value, acc);
  }

  public PacketData unserialize(ByteBuf buf) {
    return unserialize_PacketData_Generic(buf);
  }

  void serialize_PacketData_Generic(PacketData value, ByteBuf acc) {
    serialize_PacketData_Concretic(value, acc);
  }

  PacketData unserialize_PacketData_Generic(ByteBuf buf) {
    return unserialize_PacketData_Concretic(buf);
  }

  void serialize_PacketData_Concretic(PacketData value, ByteBuf acc) {
    serialize_Long_Generic(value.getTime(), acc);
  }

  PacketData unserialize_PacketData_Concretic(ByteBuf buf) {
    PacketData value = new PacketData(unserialize_Long_Generic(buf));
    return value;
  }
}
