/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml.collections;

import by.fxg.basicfml.math.MathUtils;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public final class GDXArray<T>
implements Iterable<T> {
    public T[] items;
    public int size;
    public boolean ordered;
    private final ArrayIterator cachedIterator;

    public GDXArray() {
        this(false, true, 16);
    }

    public GDXArray(int capacity) {
        this(false, true, capacity);
    }

    public GDXArray(boolean ordered) {
        this(false, ordered, 16);
    }

    public GDXArray(boolean cacheIterator, boolean ordered, int capacity) {
        this.ordered = ordered;
        this.items = new Object[capacity];
        this.cachedIterator = cacheIterator ? new ArrayIterator(this, true) : null;
    }

    public void add(T value) {
        T[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size++] = value;
    }

    public void add(T value1, T value2) {
        T[] items = this.items;
        if (this.size + 1 >= items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        this.size += 2;
    }

    public void add(T value1, T value2, T value3) {
        T[] items = this.items;
        if (this.size + 2 >= items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        items[this.size + 2] = value3;
        this.size += 3;
    }

    public void add(T value1, T value2, T value3, T value4) {
        T[] items = this.items;
        if (this.size + 3 >= items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.8f)));
        }
        items[this.size] = value1;
        items[this.size + 1] = value2;
        items[this.size + 2] = value3;
        items[this.size + 3] = value4;
        this.size += 4;
    }

    public void addAll(GDXArray<? extends T> array) {
        this.addAll(array.items, 0, array.size);
    }

    public void addAll(GDXArray<? extends T> array, int start, int count) {
        if (start + count > array.size) {
            throw new IllegalArgumentException("start + count must be <= size: " + start + " + " + count + " <= " + array.size);
        }
        this.addAll(array.items, start, count);
    }

    public void addAll(T ... array) {
        this.addAll(array, 0, array.length);
    }

    public void addAll(T[] array, int start, int count) {
        int sizeNeeded = this.size + count;
        T[] items = this.items;
        if (sizeNeeded > items.length) {
            items = this.resize(Math.max(Math.max(8, sizeNeeded), (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(array, start, items, this.size, count);
        this.size = sizeNeeded;
    }

    public T get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        return this.items[index];
    }

    public void set(int index, T value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        this.items[index] = value;
    }

    public void insert(int index, T value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        T[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(items, index, items, index + 1, this.size - index);
        } else {
            items[this.size] = items[index];
        }
        ++this.size;
        items[index] = value;
    }

    public void insertRange(int index, int count) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        int sizeNeeded = this.size + count;
        if (sizeNeeded > this.items.length) {
            this.items = this.resize(Math.max(Math.max(8, sizeNeeded), (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(this.items, index, this.items, index + count, this.size - index);
        this.size = sizeNeeded;
    }

    public void swap(int first, int second) {
        if (first >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + first + " >= " + this.size);
        }
        if (second >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + second + " >= " + this.size);
        }
        T[] items = this.items;
        T firstValue = items[first];
        items[first] = items[second];
        items[second] = firstValue;
    }

    public boolean contains(@Nullable T value, boolean identity) {
        T[] items = this.items;
        int i = this.size - 1;
        if (identity || value == null) {
            while (i >= 0) {
                if (items[i--] != value) continue;
                return true;
            }
        } else {
            while (i >= 0) {
                if (!value.equals(items[i--])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsAll(GDXArray<? extends T> values, boolean identity) {
        T[] items = values.items;
        int n = values.size;
        for (int i = 0; i < n; ++i) {
            if (this.contains(items[i], identity)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(GDXArray<? extends T> values, boolean identity) {
        T[] items = values.items;
        int n = values.size;
        for (int i = 0; i < n; ++i) {
            if (!this.contains(items[i], identity)) continue;
            return true;
        }
        return false;
    }

    public int indexOf(@Nullable T value, boolean identity) {
        T[] items = this.items;
        if (identity || value == null) {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (items[i] != value) continue;
                return i;
            }
        } else {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!value.equals(items[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(@Nullable T value, boolean identity) {
        T[] items = this.items;
        if (identity || value == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (items[i] != value) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!value.equals(items[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean removeValue(@Nullable T value, boolean identity) {
        T[] items = this.items;
        if (identity || value == null) {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (items[i] != value) continue;
                this.removeIndex(i);
                return true;
            }
        } else {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!value.equals(items[i])) continue;
                this.removeIndex(i);
                return true;
            }
        }
        return false;
    }

    public T removeIndex(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        T[] items = this.items;
        T value = items[index];
        --this.size;
        if (this.ordered) {
            System.arraycopy(items, index + 1, items, index, this.size - index);
        } else {
            items[index] = items[this.size];
        }
        items[this.size] = null;
        return value;
    }

    public void removeRange(int start, int end) {
        int i;
        int n = this.size;
        if (end >= n) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end + " >= " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start + " > " + end);
        }
        T[] items = this.items;
        int count = end - start + 1;
        int lastIndex = n - count;
        if (this.ordered) {
            System.arraycopy(items, start + count, items, start, n - (start + count));
        } else {
            i = Math.max(lastIndex, end + 1);
            System.arraycopy(items, i, items, start, n - i);
        }
        for (i = lastIndex; i < n; ++i) {
            items[i] = null;
        }
        this.size = n - count;
    }

    public boolean removeAll(GDXArray<? extends T> array, boolean identity) {
        int size;
        int startSize = size = this.size;
        T[] items = this.items;
        if (identity) {
            int n = array.size;
            block0: for (int i = 0; i < n; ++i) {
                T item = array.get(i);
                for (int ii = 0; ii < size; ++ii) {
                    if (item != items[ii]) continue;
                    this.removeIndex(ii);
                    --size;
                    continue block0;
                }
            }
        } else {
            int n = array.size;
            block2: for (int i = 0; i < n; ++i) {
                T item = array.get(i);
                for (int ii = 0; ii < size; ++ii) {
                    if (!item.equals(items[ii])) continue;
                    this.removeIndex(ii);
                    --size;
                    continue block2;
                }
            }
        }
        return size != startSize;
    }

    public T pop() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        --this.size;
        T item = this.items[this.size];
        this.items[this.size] = null;
        return item;
    }

    public T peek() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[this.size - 1];
    }

    public T first() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[0];
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        Arrays.fill(this.items, 0, this.size, null);
        this.size = 0;
    }

    public T[] shrink() {
        if (this.items.length != this.size) {
            this.resize(this.size);
        }
        return this.items;
    }

    public T[] ensureCapacity(int additionalCapacity) {
        if (additionalCapacity < 0) {
            throw new IllegalArgumentException("additionalCapacity must be >= 0: " + additionalCapacity);
        }
        int sizeNeeded = this.size + additionalCapacity;
        if (sizeNeeded > this.items.length) {
            this.resize(Math.max(Math.max(8, sizeNeeded), (int)((float)this.size * 1.75f)));
        }
        return this.items;
    }

    public T[] setSize(int newSize) {
        this.truncate(newSize);
        if (newSize > this.items.length) {
            this.resize(Math.max(8, newSize));
        }
        this.size = newSize;
        return this.items;
    }

    protected T[] resize(int newSize) {
        T[] items = this.items;
        Object[] newItems = (Object[])GDXArray.newInstance(items.getClass().getComponentType(), newSize);
        System.arraycopy(items, 0, newItems, 0, Math.min(this.size, newItems.length));
        this.items = newItems;
        return newItems;
    }

    public void reverse() {
        T[] items = this.items;
        int lastIndex = this.size - 1;
        int n = this.size / 2;
        for (int i = 0; i < n; ++i) {
            int ii = lastIndex - i;
            T temp = items[i];
            items[i] = items[ii];
            items[ii] = temp;
        }
    }

    public void shuffle() {
        T[] items = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            int ii = MathUtils.random.nextInt(i + 1);
            T temp = items[i];
            items[i] = items[ii];
            items[ii] = temp;
        }
    }

    @Override
    public ArrayIterator<T> iterator() {
        if (this.cachedIterator != null) {
            this.cachedIterator.reset();
            return this.cachedIterator;
        }
        return new ArrayIterator(this, true);
    }

    public void truncate(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("newSize must be >= 0: " + newSize);
        }
        if (this.size <= newSize) {
            return;
        }
        for (int i = newSize; i < this.size; ++i) {
            this.items[i] = null;
        }
        this.size = newSize;
    }

    @Nullable
    public T random() {
        if (this.size == 0) {
            return null;
        }
        return this.items[MathUtils.random.nextInt(this.size)];
    }

    public T[] toArray() {
        return this.toArray(this.items.getClass().getComponentType());
    }

    public <V> V[] toArray(Class<V> type) {
        Object[] result = (Object[])GDXArray.newInstance(type, this.size);
        System.arraycopy(this.items, 0, result, 0, this.size);
        return result;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        T[] items = this.items;
        int h = 1;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            h *= 31;
            T item = items[i];
            if (item == null) continue;
            h += item.hashCode();
        }
        return h;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof GDXArray)) {
            return false;
        }
        GDXArray array = (GDXArray)object;
        if (!array.ordered) {
            return false;
        }
        int n = this.size;
        if (n != array.size) {
            return false;
        }
        T[] items1 = this.items;
        T[] items2 = array.items;
        for (int i = 0; i < n; ++i) {
            T o1 = items1[i];
            T o2 = items2[i];
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIdentity(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof GDXArray)) {
            return false;
        }
        GDXArray array = (GDXArray)object;
        if (!array.ordered) {
            return false;
        }
        int n = this.size;
        if (n != array.size) {
            return false;
        }
        T[] items1 = this.items;
        T[] items2 = array.items;
        for (int i = 0; i < n; ++i) {
            if (items1[i] == items2[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        T[] items = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        buffer.append(items[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(", ");
            buffer.append(items[i]);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "";
        }
        T[] items = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append(items[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(separator);
            buffer.append(items[i]);
        }
        return buffer.toString();
    }

    private static Object newInstance(Class c, int size) {
        return Array.newInstance(c, size);
    }

    public static class ArrayIterator<T>
    implements Iterator<T>,
    Iterable<T> {
        private final GDXArray<T> array;
        private final boolean allowRemove;
        int index;
        boolean valid = true;

        public ArrayIterator(GDXArray<T> array) {
            this(array, true);
        }

        public ArrayIterator(GDXArray<T> array, boolean allowRemove) {
            this.array = array;
            this.allowRemove = allowRemove;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.array.size;
        }

        @Override
        public T next() {
            if (this.index >= this.array.size) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.array.items[this.index++];
        }

        @Override
        public void remove() {
            if (!this.allowRemove) {
                throw new RuntimeException("Remove not allowed.");
            }
            --this.index;
            this.array.removeIndex(this.index);
        }

        public void reset() {
            this.index = 0;
        }

        @Override
        public ArrayIterator<T> iterator() {
            return this;
        }
    }
}

