/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml.collections;

import java.util.HashMap;
import java.util.Map;

public class ObjectReferenceHolder<K, V> {
    protected Map<K, ObjectReference<V>> map = new HashMap<K, ObjectReference<V>>();

    public boolean hasReference(K key) {
        return this.map.containsKey(key);
    }

    public void createReference(K key, V value) {
        this.createReference(key, value, 1);
    }

    public void createReference(K key, V value, int referentsCount) {
        ObjectReference valueRef = new ObjectReference();
        valueRef.objectReference = value;
        valueRef.referents = referentsCount;
        this.map.put(key, valueRef);
    }

    public V claimReference(K key) {
        ObjectReference<V> ref = this.map.get(key);
        if (ref != null) {
            ++ref.referents;
            return (V)ref.objectReference;
        }
        return null;
    }

    public void freeReference(K key) {
        ObjectReference<V> ref = this.map.get(key);
        if (ref != null) {
            --ref.referents;
            if (ref.referents < 1) {
                this.map.remove(key);
            }
        }
    }

    protected class ObjectReference<T> {
        protected T objectReference;
        protected int referents;

        protected ObjectReference() {
        }
    }
}

