/*
 * Decompiled with CFR 0.152.
 */
package by.fxg.basicfml.configv2.intermediary;

import by.fxg.basicfml.configv2.intermediary.IntermediaryCompound;
import by.fxg.basicfml.configv2.intermediary.IntermediaryPrimitive;
import by.fxg.basicfml.configv2.intermediary.IntermediaryPrimitiveBoolean;
import by.fxg.basicfml.configv2.intermediary.IntermediaryPrimitiveNumber;
import by.fxg.basicfml.configv2.intermediary.IntermediaryPrimitiveString;
import by.fxg.basicfml.configv2.intermediary.IntermediaryWrapper;
import by.fxg.basicfml.configv2.model.ConfigArray;
import by.fxg.basicfml.configv2.model.ConfigWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class IntermediaryArray
extends IntermediaryWrapper
implements ConfigArray<IntermediaryWrapper, IntermediaryWrapper>,
Iterable<IntermediaryWrapper> {
    private List<IntermediaryWrapper> list = new ArrayList<IntermediaryWrapper>();

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean containsArrays() {
        for (int index = 0; index < this.list.size(); ++index) {
            if (!(this.list.get(index) instanceof IntermediaryArray)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsCompounds() {
        for (int index = 0; index < this.list.size(); ++index) {
            if (!(this.list.get(index) instanceof IntermediaryCompound)) continue;
            return true;
        }
        return false;
    }

    public IntermediaryWrapper getNodeAt(int index) {
        if (index > -1 && index < this.list.size()) {
            return this.list.get(index);
        }
        return null;
    }

    public IntermediaryArray getArrayAt(int index) {
        if (index > -1 && index < this.list.size()) {
            IntermediaryWrapper wrapper = this.list.get(index);
            return wrapper instanceof IntermediaryArray ? (IntermediaryArray)wrapper : null;
        }
        return null;
    }

    public IntermediaryCompound getCompoundAt(int index) {
        if (index > -1 && index < this.list.size()) {
            IntermediaryWrapper wrapper = this.list.get(index);
            return wrapper instanceof IntermediaryCompound ? (IntermediaryCompound)wrapper : null;
        }
        return null;
    }

    public IntermediaryPrimitive getPrimitiveAt(int index) {
        if (index > -1 && index < this.list.size()) {
            IntermediaryWrapper wrapper = this.list.get(index);
            return wrapper instanceof IntermediaryPrimitive ? (IntermediaryPrimitive)wrapper : null;
        }
        return null;
    }

    public IntermediaryArray appendNode(ConfigWrapper<IntermediaryWrapper> node) {
        if (!(node instanceof IntermediaryWrapper)) {
            throw new IllegalArgumentException("Only IntermediaryWrapper itself or it siblings could be provided as argument");
        }
        this.list.add((IntermediaryWrapper)node);
        return this;
    }

    public IntermediaryArray appendNode(ConfigWrapper<IntermediaryWrapper> node, String comment) {
        if (!(node instanceof IntermediaryWrapper)) {
            throw new IllegalArgumentException("Only IntermediaryWrapper itself or it siblings could be provided as argument");
        }
        this.list.add(((IntermediaryWrapper)node).setComment(comment));
        return this;
    }

    public IntermediaryArray append(IntermediaryWrapper absNode) {
        this.list.add(absNode);
        return this;
    }

    public IntermediaryArray append(IntermediaryWrapper absNode, String comment) {
        this.list.add(absNode.setComment(comment));
        return this;
    }

    public IntermediaryArray append(boolean bool) {
        this.list.add(new IntermediaryPrimitiveBoolean(bool));
        return this;
    }

    public IntermediaryArray append(boolean bool, String comment) {
        this.list.add(new IntermediaryPrimitiveBoolean(bool).setComment(comment));
        return this;
    }

    public IntermediaryArray append(Number number) {
        this.list.add(new IntermediaryPrimitiveNumber(number));
        return this;
    }

    public IntermediaryArray append(Number number, String comment) {
        this.list.add(new IntermediaryPrimitiveNumber(number).setComment(comment));
        return this;
    }

    public IntermediaryArray append(String string) {
        this.list.add(new IntermediaryPrimitiveString(string));
        return this;
    }

    public IntermediaryArray append(String string, String comment) {
        this.list.add(new IntermediaryPrimitiveString(string).setComment(comment));
        return this;
    }

    public IntermediaryArray remove(int index) {
        if (index > -1 && index < this.list.size()) {
            this.list.remove(index);
        }
        return this;
    }

    public IntermediaryArray removeFirst() {
        this.list.remove(0);
        return this;
    }

    public IntermediaryArray removeLast() {
        this.list.remove(this.list.size() - 1);
        return this;
    }

    @Override
    public List<IntermediaryWrapper> getValue() {
        return this.list;
    }

    @Override
    public Iterator<IntermediaryWrapper> iterator() {
        return this.list.iterator();
    }
}

